/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.common;

import java.net.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.ProjectSettings;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.common.Bundle;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NetworkSettings;

public final class RemoteUtils {
    private static final Logger LOGGER = Logger.getLogger(RemoteUtils.class.getName());
    private static final boolean FETCH_ALL_LOCAL_FILES = Boolean.getBoolean("nb.php.remote.localFiles.eager");
    private static final boolean FETCH_ALL_REMOTE_FILES = Boolean.getBoolean("nb.php.remote.remoteFiles.eager");
    private static final boolean FETCH_ALL_FILES = Boolean.getBoolean("nb.php.remote.files.eager");

    private RemoteUtils() {
    }

    public static JComboBox.KeySelectionManager createRemoteConfigurationKeySelectionManager() {
        return new RemoteConfigurationKeySelectionManager();
    }

    public static boolean allFilesFetched(boolean remote) {
        if (FETCH_ALL_FILES) {
            return true;
        }
        return remote ? FETCH_ALL_REMOTE_FILES : FETCH_ALL_LOCAL_FILES;
    }

    public static long getLastTimestamp(boolean upload, Project project) {
        if (!RemoteUtils.allFilesFetched(!upload)) {
            return 4102441200L;
        }
        return upload ? ProjectSettings.getLastUpload(project) : ProjectSettings.getLastDownload(project);
    }

    public static void fetchAllFiles(boolean remote, Set<TransferFile> files, FileObject sources, FileObject[] preselectedFiles) {
        if (!RemoteUtils.allFilesFetched(remote)) {
            return;
        }
        if (preselectedFiles.length != 1) {
            return;
        }
        if (!preselectedFiles[0].equals(sources)) {
            return;
        }
        HashSet<TransferFile> tmp = new HashSet<TransferFile>();
        for (TransferFile transferFile : files) {
            RemoteUtils.fetchAllFiles(remote, tmp, transferFile);
        }
        files.clear();
        files.addAll(tmp);
    }

    private static void fetchAllFiles(boolean remote, Set<TransferFile> allFiles, TransferFile transferFile) {
        allFiles.add(transferFile);
        List<TransferFile> children = remote ? transferFile.getRemoteChildren() : transferFile.getLocalChildren();
        for (TransferFile child : children) {
            RemoteUtils.fetchAllFiles(remote, allFiles, child);
        }
    }

    public static void processRemoteException(RemoteException remoteException) {
        String title = Bundle.LBL_RemoteError();
        StringBuilder message = new StringBuilder(remoteException.getMessage());
        String remoteServerAnswer = remoteException.getRemoteServerAnswer();
        Throwable cause = remoteException.getCause();
        if (remoteServerAnswer != null && remoteServerAnswer.length() > 0) {
            message.append(Bundle.MSG_RemoteErrorReason(remoteServerAnswer));
        } else if (cause != null) {
            message.append(Bundle.MSG_RemoteErrorReason(cause.getMessage()));
        }
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)message.toString(), title, 2, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notifyLater(notifyDescriptor);
    }

    public static String sanitizeDirectoryPath(String directoryPath) {
        while (!directoryPath.equals("/") && directoryPath.endsWith("/")) {
            LOGGER.log(Level.FINE, "Removing ending slash from directory {0}", directoryPath);
            directoryPath = directoryPath.substring(0, directoryPath.length() - "/".length());
        }
        return directoryPath;
    }

    public static String sanitizeUploadDirectory(String uploadDirectory, boolean allowEmpty) {
        if (StringUtils.hasText((String)uploadDirectory)) {
            while (uploadDirectory.length() > 1 && uploadDirectory.endsWith("/")) {
                uploadDirectory = uploadDirectory.substring(0, uploadDirectory.length() - 1);
            }
        } else if (!allowEmpty) {
            uploadDirectory = "/";
        }
        if (allowEmpty && (uploadDirectory == null || "/".equals(uploadDirectory))) {
            uploadDirectory = "";
        }
        return uploadDirectory;
    }

    public static String getParentPath(String path) {
        ArrayList parts;
        if (path.equals("/")) {
            return null;
        }
        boolean absolute = path.startsWith("/");
        if (absolute) {
            path = path.substring(1);
        }
        if ((parts = new ArrayList(StringUtils.explode((String)path, (String)"/"))).size() <= 1) {
            return absolute ? "/" : null;
        }
        parts.remove(parts.size() - 1);
        String parent = StringUtils.implode(parts, (String)"/");
        if (absolute) {
            return "/" + parent;
        }
        return parent;
    }

    public static String getName(String path) {
        if (path.equals("/")) {
            return "/";
        }
        ArrayList parts = new ArrayList(StringUtils.explode((String)path, (String)"/"));
        return (String)parts.get(parts.size() - 1);
    }

    public static boolean hasHttpProxy(String host) {
        return RemoteUtils.getHttpProxy(host) != null;
    }

    @CheckForNull
    public static ProxyInfo getHttpProxy(String host) {
        return RemoteUtils.getProxy(Proxy.Type.HTTP, host);
    }

    @CheckForNull
    public static ProxyInfo getSocksProxy(String host) {
        return RemoteUtils.getProxy(Proxy.Type.SOCKS, host);
    }

    private static ProxyInfo getProxy(Proxy.Type type, String host) {
        assert (type != null);
        assert (type != Proxy.Type.DIRECT);
        URI uri = switch (type) {
            case Proxy.Type.HTTP -> URI.create("http://" + RemoteUtils.sanitizeHost(host));
            case Proxy.Type.SOCKS -> URI.create("socks://" + RemoteUtils.sanitizeHost(host));
            default -> throw new IllegalStateException("Unexpected proxy type: " + type);
        };
        String proxyHost = NetworkSettings.getProxyHost((URI)uri);
        if (proxyHost == null) {
            return null;
        }
        return new ProxyInfo(type, proxyHost, Integer.parseInt(NetworkSettings.getProxyPort((URI)uri)), NetworkSettings.getAuthenticationUsername((URI)uri), NetworkSettings.getKeyForAuthenticationPassword((URI)uri));
    }

    private static String sanitizeHost(String host) {
        if (StringUtils.hasText((String)host)) {
            return host;
        }
        return "oracle.com";
    }

    private static final class RemoteConfigurationKeySelectionManager
    implements JComboBox.KeySelectionManager {
        private RemoteConfigurationKeySelectionManager() {
        }

        public int selectionForKey(char key, ComboBoxModel model) {
            char firstChar = ("" + key).toLowerCase().charAt(0);
            for (int i = 0; i < model.getSize(); ++i) {
                RemoteConfiguration configuration = (RemoteConfiguration)model.getElementAt(i);
                if (configuration.getDisplayName().charAt(0) != firstChar) continue;
                return i;
            }
            return -1;
        }
    }

    public static final class ProxyInfo {
        private final Proxy.Type type;
        private final String host;
        private final int port;
        private final String username;
        private final String passwordKey;

        public ProxyInfo(Proxy.Type type, String host, int port, String username, String passwordKey) {
            assert (type != null);
            assert (host != null);
            this.type = type;
            this.host = host;
            this.port = port;
            this.username = username;
            this.passwordKey = passwordKey;
        }

        public Proxy.Type getType() {
            return this.type;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            if (this.passwordKey == null) {
                return null;
            }
            char[] chars = Keyring.read((String)this.passwordKey);
            if (chars == null) {
                return null;
            }
            return new String(chars);
        }

        public String toString() {
            return "ProxyInfo{type=" + this.type + ", host=" + this.host + ", port=" + this.port + ", username=" + this.username + ", passwordKey=" + this.passwordKey + "}";
        }
    }
}

