/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.Domain;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.IPv4Address;
import io.mola.galimatias.IPv6Address;
import java.io.Serializable;

public abstract class Host
implements Serializable {
    public abstract String toString();

    public abstract String toHumanString();

    public static Host parseHost(String input) throws GalimatiasParseException {
        if (input == null) {
            throw new NullPointerException("null host");
        }
        if (input.isEmpty()) {
            throw new GalimatiasParseException("empty host", -1);
        }
        if (input.charAt(0) == '[') {
            if (input.charAt(input.length() - 1) != ']') {
                throw new GalimatiasParseException("Unmatched '['", -1);
            }
            return IPv6Address.parseIPv6Address(input.substring(1, input.length() - 1));
        }
        Domain domain = Domain.parseDomain(input);
        try {
            return IPv4Address.parseIPv4Address(domain.toString());
        }
        catch (GalimatiasParseException e) {
            return domain;
        }
    }
}

