/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;

public final class Authentication {
    public static final MethodList PASSWORD_METHODS = new MethodList(Pair.of((Object)((Object)Method.GssapiWithMic), (Object)true), Pair.of((Object)((Object)Method.PublicKey), (Object)false), Pair.of((Object)((Object)Method.KeyboardInteractive), (Object)true), Pair.of((Object)((Object)Method.Password), (Object)true));
    public static final MethodList SSH_KEY_METHODS = new MethodList(Pair.of((Object)((Object)Method.GssapiWithMic), (Object)true), Pair.of((Object)((Object)Method.PublicKey), (Object)true), Pair.of((Object)((Object)Method.KeyboardInteractive), (Object)true), Pair.of((Object)((Object)Method.Password), (Object)true));
    public static final MethodList DEFAULT_METHODS = PASSWORD_METHODS;
    private static final Preferences prefs = NbPreferences.forModule(Authentication.class);
    private static final String METHODS_SUFFIX = ".methods";
    private static final String TIMEOUT_SUFFIX = ".timeout";
    private static final boolean isUnitTest = Boolean.getBoolean("nativeexecution.mode.unittest");
    private static final String knownHostsFile;
    private static String lastSSHKeyFile;
    private final ExecutionEnvironment env;
    private final String pref_key;
    private String sshKeyFile;
    private Type type = Type.UNDEFINED;
    private MethodList authenticationMethods = DEFAULT_METHODS;
    private int timeout = Integer.getInteger("jsch.connection.timeout", 10000) / 1000;

    private Authentication(ExecutionEnvironment env) {
        this.pref_key = env == null ? null : Authentication.class.getName() + "_" + ExecutionEnvironmentFactory.toUniqueID(env);
        this.env = env;
    }

    public static Authentication getFor(ExecutionEnvironment env) {
        Authentication result = new Authentication(env);
        result.restore();
        if (isUnitTest) {
            result.setPassword();
        } else if (result.sshKeyFile == null || result.sshKeyFile.trim().length() == 0) {
            result.sshKeyFile = lastSSHKeyFile;
        }
        return result;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setAuthenticationMethods(MethodList methods) {
        this.authenticationMethods = methods;
    }

    public MethodList getAuthenticationMethods() {
        return this.authenticationMethods;
    }

    public boolean isDefined() {
        return this.type != Type.UNDEFINED;
    }

    public void setPassword() {
        if (this.type == Type.PASSWORD) {
            return;
        }
        this.type = Type.PASSWORD;
    }

    public String getKnownHostsFile() {
        return knownHostsFile;
    }

    public void setSSHKeyFile(String filename) throws IllegalArgumentException {
        if (!Authentication.isValidSSHKeyFile(filename)) {
            throw new IllegalArgumentException("Invalid ssh key file " + filename);
        }
        this.type = Type.SSH_KEY;
        this.sshKeyFile = filename;
    }

    public static boolean isValidSSHKeyFile(String filename) {
        JSch test = new JSch();
        try {
            test.addIdentity(filename);
        }
        catch (JSchException ex) {
            return false;
        }
        return true;
    }

    private static boolean isValidKnownHostsFile(String knownHostsFile) {
        JSch test = new JSch();
        try {
            test.setKnownHosts(knownHostsFile);
        }
        catch (JSchException ex) {
            return false;
        }
        return true;
    }

    public Type getType() {
        return this.type;
    }

    public void store() {
        if (this.env == null) {
            return;
        }
        if (this.type == Type.SSH_KEY) {
            prefs.put(this.pref_key, this.sshKeyFile);
            lastSSHKeyFile = this.sshKeyFile;
        } else {
            prefs.put(this.pref_key, this.type.name());
        }
        prefs.put(this.pref_key + METHODS_SUFFIX, this.authenticationMethods.toStorageString());
        prefs.putInt(this.pref_key + TIMEOUT_SUFFIX, this.timeout);
    }

    private void restore() {
        if (this.env == null) {
            return;
        }
        String typeOrKey = prefs.get(this.pref_key, Type.UNDEFINED.name());
        if (Type.UNDEFINED.name().equals(typeOrKey)) {
            this.type = Type.UNDEFINED;
        } else if (Type.PASSWORD.name().equals(typeOrKey)) {
            this.type = Type.PASSWORD;
        } else if (Authentication.isValidSSHKeyFile(typeOrKey)) {
            this.type = Type.SSH_KEY;
            this.sshKeyFile = typeOrKey;
        } else {
            this.type = Type.UNDEFINED;
        }
        String storedText = prefs.get(this.pref_key + METHODS_SUFFIX, null);
        if (storedText != null && !storedText.isEmpty()) {
            this.authenticationMethods = MethodList.fromStorageString(storedText);
        }
        this.timeout = prefs.getInt(this.pref_key + TIMEOUT_SUFFIX, this.timeout);
    }

    public ExecutionEnvironment getEnv() {
        return this.env;
    }

    public void remove() {
        if (this.pref_key != null) {
            prefs.remove(this.pref_key);
        }
    }

    public void apply() {
        if (this.env == null) {
            return;
        }
        this.store();
        ConnectionManagerAccessor access = ConnectionManagerAccessor.getDefault();
        access.changeAuth(this.env, this);
    }

    public String getKey() {
        return this.getSSHKeyFile();
    }

    public String getSSHKeyFile() {
        return this.sshKeyFile;
    }

    static {
        Object hosts = System.getProperty("ssh.knonwhosts.file", null);
        if (!(hosts != null && Authentication.isValidKnownHostsFile((String)hosts) || Authentication.isValidKnownHostsFile((String)(hosts = System.getProperty("user.home") + "/.ssh/known_hosts")) || Authentication.isValidKnownHostsFile((String)(hosts = System.getProperty("netbeans.user") + "/.ssh/known_hosts")))) {
            hosts = null;
        }
        knownHostsFile = hosts;
        String key = System.getProperty("user.home") + "/.ssh/id_dsa";
        if (!Authentication.isValidSSHKeyFile(key) && !Authentication.isValidSSHKeyFile(key = System.getProperty("user.home") + "/.ssh/id_rsa")) {
            key = null;
        }
        lastSSHKeyFile = key;
    }

    public static enum Type {
        UNDEFINED,
        PASSWORD,
        SSH_KEY;

    }

    public static class MethodList {
        private final Method[] methods;
        private final boolean[] enabled;

        public MethodList(List<Pair<Method, Boolean>> pairs) {
            this.methods = new Method[pairs.size()];
            this.enabled = new boolean[pairs.size()];
            for (int i = 0; i < pairs.size(); ++i) {
                this.methods[i] = (Method)((Object)pairs.get(i).first());
                this.enabled[i] = (Boolean)pairs.get(i).second();
            }
        }

        public MethodList(Pair<Method, Boolean> ... pairs) {
            this.methods = new Method[pairs.length];
            this.enabled = new boolean[pairs.length];
            for (int i = 0; i < pairs.length; ++i) {
                this.methods[i] = (Method)((Object)pairs[i].first());
                this.enabled[i] = (Boolean)pairs[i].second();
            }
        }

        public String toJschString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.methods.length; ++i) {
                if (!this.enabled[i]) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(this.methods[i].getID());
            }
            return sb.toString();
        }

        public String toStorageString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.methods.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(this.methods[i].getID());
                sb.append('#');
                sb.append(this.enabled[i] ? (char)'1' : '0');
            }
            return sb.toString();
        }

        public boolean isEmpty() {
            return this.methods.length == 0;
        }

        public Method[] getMethods() {
            return (Method[])this.methods.clone();
        }

        public boolean isEnabled(Method method) {
            for (int i = 0; i < this.methods.length; ++i) {
                if (this.methods[i] != method) continue;
                return this.enabled[i];
            }
            return false;
        }

        public boolean hasKeyFile() {
            for (int i = 0; i < this.methods.length; ++i) {
                if (!this.enabled[i] || !this.methods[i].hasKeyFile()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.toStorageString();
        }

        public int hashCode() {
            int hash = 5;
            hash = 89 * hash + Arrays.deepHashCode((Object[])this.methods);
            hash = 89 * hash + Arrays.hashCode(this.enabled);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodList other = (MethodList)obj;
            if (!Arrays.deepEquals((Object[])this.methods, (Object[])other.methods)) {
                return false;
            }
            return Arrays.equals(this.enabled, other.enabled);
        }

        private static MethodList fromStorageString(String methodsList) {
            ArrayList<Pair<Method, Boolean>> pairs = new ArrayList<Pair<Method, Boolean>>();
            String[] parts = methodsList.split(",");
            for (int i = 0; i < parts.length; ++i) {
                boolean enabled;
                String name;
                String part = parts[i];
                if (part.isEmpty()) continue;
                if (part.endsWith("#1")) {
                    name = part.substring(0, part.length() - 2);
                    enabled = true;
                } else if (part.endsWith("#0")) {
                    name = part.substring(0, part.length() - 2);
                    enabled = false;
                } else {
                    name = part;
                    enabled = true;
                }
                Method method = Method.byID(name);
                if (method == null) continue;
                pairs.add((Pair<Method, Boolean>)Pair.of((Object)((Object)method), (Object)enabled));
            }
            return new MethodList(pairs);
        }
    }

    public static enum Method {
        GssapiWithMic("gssapi-with-mic", false),
        PublicKey("publickey", true),
        KeyboardInteractive("keyboard-interactive", false),
        Password("password", false);

        private final String id;
        private final boolean hasKeyFile;

        private Method(String name, boolean hasKeyFile) {
            this.id = name;
            this.hasKeyFile = hasKeyFile;
        }

        public String getID() {
            return this.id;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Authentication.class, (String)("Authentication." + this.id));
        }

        public boolean hasKeyFile() {
            return this.hasKeyFile;
        }

        private static Method byID(String id) {
            for (Method m : Method.values()) {
                if (!m.id.equals(id)) continue;
                return m;
            }
            return null;
        }
    }
}

