/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.w3c.dom.Node;

public class BrkpntSetResponse
extends DbgpResponse {
    private static final String STATE = "state";
    private static final String ID = "id";
    private static final String ERROR = "error";
    private static final String MESSAGE = "message";

    BrkpntSetResponse(Node node) {
        super(node);
    }

    public String getBreakpointId() {
        return BrkpntSetResponse.getAttribute(this.getNode(), ID);
    }

    public BrkpntSetCommand.State getState() {
        String state = BrkpntSetResponse.getAttribute(this.getNode(), STATE);
        return BrkpntSetCommand.State.forString(state);
    }

    @Override
    public void process(DebugSession session, DbgpCommand command) {
        Node message;
        if (!(command instanceof BrkpntSetCommand)) {
            return;
        }
        BrkpntSetCommand setCommand = (BrkpntSetCommand)command;
        AbstractBreakpoint breakpoint = setCommand.getBreakpoint();
        if (breakpoint == null) {
            return;
        }
        Node error = BrkpntSetResponse.getChild(this.getNode(), ERROR);
        if (error != null && (message = BrkpntSetResponse.getChild(error, MESSAGE)) != null) {
            breakpoint.setInvalid(message.getTextContent());
            return;
        }
        breakpoint.setBreakpointId(this.getBreakpointId());
        if (this.getState() == BrkpntSetCommand.State.DISABLED) {
            breakpoint.disable();
        } else {
            breakpoint.enable();
        }
    }
}

