/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.SessionMethodController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session.MethodChildren;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbViewController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.MethodsNode;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class SessionChildren
extends Children.Keys<Key>
implements PropertyChangeListener {
    private static final int REMOTE = 0;
    private static final int LOCAL = 1;
    private static final int BEAN = 2;
    private final ClasspathInfo cpInfo;
    private final String ejbClass;
    private final EjbJar ejbModule;
    private final SessionMethodController controller;
    private static final RequestProcessor RP = new RequestProcessor(SessionChildren.class.getName(), 5);

    public SessionChildren(EjbViewController ejbViewController) {
        this.cpInfo = ejbViewController.getClasspathInfo();
        this.ejbClass = ejbViewController.getEjbClass();
        this.ejbModule = ejbViewController.getEjbModule();
        this.controller = new SessionMethodController(this.ejbClass, (MetadataModel<EjbJarMetadata>)this.ejbModule.getMetadataModel());
    }

    protected void addNotify() {
        super.addNotify();
        try {
            this.updateKeys();
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    private void updateKeys() throws IOException {
        RP.submit(new Runnable(){

            @Override
            public void run() {
                final boolean[] results = new boolean[]{false, false, true};
                try {
                    SessionChildren.this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                        public Void run(EjbJarMetadata metadata) throws Exception {
                            Session entity = (Session)metadata.findByEjbClass(SessionChildren.this.ejbClass);
                            if (entity != null) {
                                results[0] = entity.getRemote() != null;
                                results[1] = entity.getLocal() != null;
                                entity.removePropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)SessionChildren.this, (Object)entity));
                                entity.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)SessionChildren.this, (Object)entity));
                            }
                            return null;
                        }
                    });
                    SessionChildren.this.controller.refresh();
                }
                catch (MetadataModelException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<Key> keys = new ArrayList<Key>();
                        if (results[0]) {
                            keys.add(Key.REMOTE);
                        }
                        if (results[1]) {
                            keys.add(Key.LOCAL);
                        }
                        if (results[2]) {
                            keys.add(Key.BEAN);
                        }
                        SessionChildren.this.setKeys(keys);
                    }
                });
            }
        });
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptyList());
        super.removeNotify();
    }

    protected Node[] createNodes(Key key) {
        if (Key.LOCAL == key) {
            MethodChildren children = new MethodChildren(this, this.cpInfo, this.ejbModule, this.controller, MethodsNode.ViewType.LOCAL);
            MethodsNode n = new MethodsNode(this.ejbClass, this.ejbModule, (Children)children, MethodsNode.ViewType.LOCAL);
            n.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/LocalMethodContainerIcon.gif");
            n.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_LocalMethods"));
            return new Node[]{n};
        }
        if (Key.REMOTE == key) {
            MethodChildren children = new MethodChildren(this, this.cpInfo, this.ejbModule, this.controller, MethodsNode.ViewType.REMOTE);
            MethodsNode n = new MethodsNode(this.ejbClass, this.ejbModule, (Children)children, MethodsNode.ViewType.REMOTE);
            n.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/RemoteMethodContainerIcon.gif");
            n.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_RemoteMethods"));
            return new Node[]{n};
        }
        if (Key.BEAN == key) {
            MethodChildren children = new MethodChildren(this, this.cpInfo, this.ejbModule, this.controller, MethodsNode.ViewType.NO_INTERFACE);
            MethodsNode n = new MethodsNode(this.ejbClass, this.ejbModule, (Children)children, MethodsNode.ViewType.NO_INTERFACE);
            n.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/MethodContainerIcon.gif");
            n.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_BeanMethods"));
            return new Node[]{n};
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String prop = propertyChangeEvent.getPropertyName();
        if ("BusinessLocal".equals(prop) || "BusinessRemote".equals(prop) || "TYPE_CHANGE".equals(prop)) {
            try {
                this.updateKeys();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static enum Key {
        REMOTE,
        LOCAL,
        BEAN;

    }
}

