/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.bindings.java;

import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.spellchecker.spi.language.TokenList;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JavaTokenList
implements TokenList {
    private final Document doc;
    private boolean hidden = false;
    private int currentBlockStart;
    private int nextBlockStart;
    private String currentBlockText;
    private int currentOffsetInComment;
    private int currentWordOffset;
    private CharSequence currentWord;
    private int startOffset;
    private static final Pattern commentPattern = Pattern.compile("/\\*\\*([^*]*(\\*[^/][^*]*)*)\\*/", 40);
    private static final Pattern wordPattern = Pattern.compile("[A-Za-z]+");

    public JavaTokenList(Document doc) {
        this.doc = doc;
    }

    public void setStartOffset(int offset) {
        this.currentBlockText = null;
        this.currentOffsetInComment = -1;
        this.startOffset = this.nextBlockStart = offset;
        FileObject fileObject = FileUtil.getConfigFile((String)"Spellcheckers/Javadoc");
        Boolean b = (Boolean)fileObject.getAttribute("Hidden");
        this.hidden = Boolean.TRUE.equals(b);
    }

    public int getCurrentWordStartOffset() {
        return this.currentWordOffset;
    }

    public CharSequence getCurrentWordText() {
        return this.currentWord;
    }

    public boolean nextWord() {
        if (this.hidden) {
            return false;
        }
        boolean hasNext = this.nextWordImpl();
        while (hasNext && this.currentWordOffset + this.currentWord.length() < this.startOffset) {
            hasNext = this.nextWordImpl();
        }
        return hasNext;
    }

    private int[] findNextJavaDocComment() throws BadLocationException {
        TokenHierarchy h = TokenHierarchy.get((Document)this.doc);
        TokenSequence ts = h.tokenSequence(JavaTokenId.language());
        if (ts == null) {
            return new int[]{-1, -1};
        }
        int diff = ts.move(this.nextBlockStart);
        while (ts.moveNext()) {
            if (ts.token().id() != JavaTokenId.JAVADOC_COMMENT) continue;
            return new int[]{ts.offset(), ts.offset() + ts.token().length()};
        }
        while (ts.moveNext()) {
        }
        return new int[]{-1, -1};
    }

    private void handleJavadocTag(CharSequence tag) {
        if ("@see".contentEquals(tag) || "@throws".contentEquals(tag)) {
            Pair<CharSequence, Integer> data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, true);
            this.currentOffsetInComment = (Integer)data.b + ((CharSequence)data.a).length();
            return;
        }
        if ("@param".contentEquals(tag)) {
            Pair<CharSequence, Integer> data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, false);
            this.currentOffsetInComment = (Integer)data.b + ((CharSequence)data.a).length();
            return;
        }
        if ("@author".contentEquals(tag)) {
            Pair<CharSequence, Integer> data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, false);
            while (data != null) {
                this.currentOffsetInComment = (Integer)data.b + ((CharSequence)data.a).length();
                if ('\n' == ((CharSequence)data.a).charAt(0)) {
                    return;
                }
                data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, false);
            }
            return;
        }
    }

    private boolean nextWordImpl() {
        try {
            while (true) {
                if (this.currentBlockText == null) {
                    int[] span = this.findNextJavaDocComment();
                    if (span[0] == -1) {
                        return false;
                    }
                    this.currentBlockStart = span[0];
                    this.currentBlockText = this.doc.getText(span[0], span[1] - span[0]);
                    this.currentOffsetInComment = 0;
                    this.nextBlockStart = span[1];
                }
                String pairTag = null;
                Pair<CharSequence, Integer> data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, false);
                while (data != null) {
                    this.currentOffsetInComment = (Integer)data.b + ((CharSequence)data.a).length();
                    if (pairTag == null) {
                        if (Character.isLetter(((CharSequence)data.a).charAt(0)) && !JavaTokenList.isIdentifierLike((CharSequence)data.a)) {
                            this.currentWordOffset = this.currentBlockStart + (Integer)data.b;
                            this.currentWord = (CharSequence)data.a;
                            return true;
                        }
                        switch (((CharSequence)data.a).charAt(0)) {
                            case '@': {
                                this.handleJavadocTag((CharSequence)data.a);
                                break;
                            }
                            case '<': {
                                if (JavaTokenList.startsWith((CharSequence)data.a, "<a ")) {
                                    pairTag = "</a>";
                                }
                                if (JavaTokenList.startsWith((CharSequence)data.a, "<code>")) {
                                    pairTag = "</code>";
                                }
                                if (!JavaTokenList.startsWith((CharSequence)data.a, "<pre>")) break;
                                pairTag = "</pre>";
                                break;
                            }
                            case '{': {
                                pairTag = "}";
                            }
                        }
                    } else if (pairTag.contentEquals((CharSequence)data.a)) {
                        pairTag = null;
                    }
                    data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, false);
                }
                this.currentBlockText = null;
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return false;
        }
    }

    private static boolean startsWith(CharSequence where, String withWhat) {
        if (where.length() >= withWhat.length()) {
            return withWhat.contentEquals(where.subSequence(0, withWhat.length()));
        }
        return false;
    }

    static boolean isIdentifierLike(CharSequence s) {
        boolean hasCapitalsInside = false;
        for (int offset = 1; offset < s.length() && !hasCapitalsInside; hasCapitalsInside |= Character.isUpperCase(s.charAt(offset)), ++offset) {
        }
        return hasCapitalsInside;
    }

    private boolean isLetter(char c) {
        return Character.isLetter(c) || c == '\'';
    }

    private Pair<CharSequence, Integer> wordBroker(CharSequence start, int offset, boolean treatSpecialCharactersAsLetterInsideWords) {
        int state = 0;
        int offsetStart = offset;
        while (start.length() > offset) {
            char current = start.charAt(offset);
            switch (state) {
                case 0: {
                    if (this.isLetter(current)) {
                        state = 1;
                        offsetStart = offset;
                        break;
                    }
                    if (current == '@' || current == '#') {
                        state = 2;
                        offsetStart = offset;
                        break;
                    }
                    if (current == '<') {
                        state = 3;
                        offsetStart = offset;
                        break;
                    }
                    if (current == '\n' || current == '}') {
                        return new Pair<CharSequence, Integer>(start.subSequence(offset, offset + 1), offset);
                    }
                    if (current == '{') {
                        state = 4;
                        offsetStart = offset;
                        break;
                    }
                    if (current != '&') break;
                    state = 5;
                    offsetStart = offset;
                    break;
                }
                case 1: {
                    if (this.isLetter(current) || (current == '.' || current == '#') && treatSpecialCharactersAsLetterInsideWords) break;
                    return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset), offsetStart);
                }
                case 2: {
                    if (this.isLetter(current)) break;
                    return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset), offsetStart);
                }
                case 3: {
                    if (current != '>') break;
                    return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset + 1), offsetStart);
                }
                case 4: {
                    if (current == '@') {
                        state = 2;
                        break;
                    }
                    --offset;
                    state = 0;
                    break;
                }
                case 5: {
                    if (current == ';') {
                        return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset + 1), offsetStart);
                    }
                    if (this.isLetter(current) || current == '#' || Character.isDigit(current)) break;
                    return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset), offsetStart);
                }
            }
            ++offset;
        }
        if (offset > offsetStart) {
            return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset), offsetStart);
        }
        return null;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private static class Pair<A, B> {
        private A a;
        private B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }
}

