/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.awt.EventQueue;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ValidatorUtils;
import org.netbeans.validation.api.conversion.Converter;
import org.netbeans.validation.api.ui.ButtonsValidationListenerImpl;
import org.netbeans.validation.api.ui.JComboBoxValidationListenerImpl;
import org.netbeans.validation.api.ui.JListValidationListenerImpl;
import org.netbeans.validation.api.ui.JTextComponentValidationListenerImpl;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationStrategy;
import org.netbeans.validation.api.ui.ValidationUI;

final class SwingValidationListenerFactories {
    private SwingValidationListenerFactories() {
    }

    static ValidationListener createJListValidationListener(JList component, ValidationStrategy strategy, ValidationUI validationUI, Validator<ListSelectionModel> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        return new JListValidationListenerImpl(component, strategy, validationUI, validator);
    }

    static ValidationListener<JList> createJListValidationListenerConverted(JList component, ValidationStrategy strategy, ValidationUI validationUI, Validator<Integer[]> orig) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        Validator validator = Converter.find(Integer[].class, ListSelectionModel.class).convert(orig);
        return new JListValidationListenerImpl(component, strategy, validationUI, (Validator<ListSelectionModel>)validator);
    }

    static ValidationListener createJTextComponentValidationListener(JTextComponent comp, ValidationStrategy strategy, ValidationUI validationUI, Validator<Document> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        return new JTextComponentValidationListenerImpl(comp, strategy, validationUI, validator);
    }

    static ValidationListener createJTextComponentValidationListener(JTextComponent comp, ValidationUI validationUI, Validator<Document> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        return new JTextComponentValidationListenerImpl(comp, ValidationStrategy.DEFAULT, validationUI, validator);
    }

    static ValidationListener createJTextComponentValidationListener(JTextComponent comp, ValidationStrategy strategy, ValidationUI validationUI, Validator<String> ... validators) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        Validator merged = ValidatorUtils.merge(validators);
        Validator validator = Converter.find(String.class, Document.class).convert(merged);
        return new JTextComponentValidationListenerImpl(comp, strategy, validationUI, (Validator<Document>)validator);
    }

    static ValidationListener createJTextComponentValidationListener(JTextComponent comp, ValidationUI validationUI, Validator<String> ... validators) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        return SwingValidationListenerFactories.createJTextComponentValidationListener(comp, ValidationStrategy.DEFAULT, validationUI, validators);
    }

    static ValidationListener createJComboBoxValidationListener(JComboBox component, ValidationStrategy strategy, ValidationUI validationUI, Validator<ComboBoxModel> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        return new JComboBoxValidationListenerImpl(component, strategy, validationUI, validator);
    }

    static ValidationListener createJComboBoxValidationListener(JComboBox component, ValidationUI validationUI, Validator<ComboBoxModel> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        return new JComboBoxValidationListenerImpl(component, ValidationStrategy.DEFAULT, validationUI, validator);
    }

    static ValidationListener createJComboBoxValidationListener(JComboBox component, ValidationStrategy strategy, ValidationUI validationUI, Validator<String> ... validators) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        Validator merged = ValidatorUtils.merge(validators);
        Validator validator = Converter.find(String.class, ComboBoxModel.class).convert(merged);
        return new JComboBoxValidationListenerImpl(component, strategy, validationUI, (Validator<ComboBoxModel>)validator);
    }

    static ValidationListener createJComboBoxValidationListener(JComboBox component, ValidationUI validationUI, Validator<String> ... validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        return SwingValidationListenerFactories.createJComboBoxValidationListener(component, ValidationStrategy.DEFAULT, validationUI, validator);
    }

    static ValidationListener createButtonsValidationListener(AbstractButton[] buttons, ValidationUI validationUI, Validator<ButtonModel[]> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        return new ButtonsValidationListenerImpl(buttons, validationUI, validator);
    }

    static ValidationListener createButtonsValidationListener(AbstractButton[] buttons, ValidationUI validationUI, Validator<Integer[]> ... validators) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        Validator merged = ValidatorUtils.merge(validators);
        Validator validator = Converter.find(Integer[].class, ButtonModel[].class).convert(merged);
        return new ButtonsValidationListenerImpl(buttons, validationUI, (Validator<ButtonModel[]>)validator);
    }
}

