/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils.formatting;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;

public class MethodNameFormatterFactory {
    private static MethodNameFormatterFactory instance;
    private final Map formatterMap;
    private MethodNameFormatter defaultFormatter;

    private MethodNameFormatterFactory() {
        this.formatterMap = new HashMap();
    }

    private MethodNameFormatterFactory(MethodNameFormatterFactory template) {
        this.formatterMap = template.formatterMap;
    }

    public static synchronized MethodNameFormatterFactory getDefault() {
        if (instance == null) {
            instance = new MethodNameFormatterFactory();
            MethodNameFormatterFactory.instance.defaultFormatter = new DefaultMethodNameFormatter();
        }
        return instance;
    }

    public static synchronized MethodNameFormatterFactory getDefault(MethodNameFormatter defaultFormatter) {
        MethodNameFormatterFactory factory = new MethodNameFormatterFactory(MethodNameFormatterFactory.getDefault());
        factory.defaultFormatter = defaultFormatter;
        return factory;
    }

    public MethodNameFormatter getFormatter() {
        return this.defaultFormatter;
    }

    public synchronized MethodNameFormatter getFormatter(Mark mark) {
        if (mark == null || mark.isDefault()) {
            return this.defaultFormatter;
        }
        MethodNameFormatter formatter = (MethodNameFormatter)this.formatterMap.get(mark);
        if (formatter == null) {
            return this.defaultFormatter;
        }
        return formatter;
    }

    public synchronized void registerFormatter(Mark mark, MethodNameFormatter formatter) {
        this.formatterMap.put(mark, formatter);
    }
}

