/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.instrumentation.CPExtensionsRepository;
import org.netbeans.lib.profiler.instrumentation.ConstantPoolExtension;

public class DynamicConstantPoolExtension
extends ConstantPoolExtension
implements CommonConstants {
    private static DynamicConstantPoolExtension emptyECP = new DynamicConstantPoolExtension();
    protected DynamicClassInfo clazz;

    protected DynamicConstantPoolExtension(DynamicClassInfo clazz, int injectionType, int baseCPCount, int secondaryCPCount) {
        super(CPExtensionsRepository.getStandardCPFragment(injectionType), baseCPCount, secondaryCPCount);
        this.clazz = clazz;
    }

    protected DynamicConstantPoolExtension() {
    }

    public static DynamicConstantPoolExtension getAllAddedCPFragments(DynamicClassInfo clazz) {
        DynamicConstantPoolExtension res = new DynamicConstantPoolExtension();
        int lowerBaseCPCountBound = 0;
        int baseCPCLen = clazz.getBaseCPoolCountLen();
        for (int j = 0; j < baseCPCLen; ++j) {
            int minBaseCPCount = 0xFFFFFFF;
            int cpFragmentIdx = -1;
            for (int i = 0; i < baseCPCLen; ++i) {
                int curCPCount = clazz.getBaseCPoolCount(i);
                if (curCPCount == -1 || curCPCount <= lowerBaseCPCountBound || curCPCount >= minBaseCPCount) continue;
                minBaseCPCount = curCPCount;
                cpFragmentIdx = i;
            }
            if (cpFragmentIdx != -1) {
                DynamicConstantPoolExtension res1 = DynamicConstantPoolExtension.newDynamicCPExtension(clazz, cpFragmentIdx, clazz.getBaseCPoolCount(cpFragmentIdx));
                res.addedCPContents = res.getConcatenatedContents(res1);
                res.nAddedEntries += res1.nAddedEntries;
            } else {
                return res;
            }
            lowerBaseCPCountBound = minBaseCPCount;
        }
        return res;
    }

    public static DynamicConstantPoolExtension getCPFragment(DynamicClassInfo clazz, int injType) {
        if (clazz.getBaseCPoolCount(injType) != -1) {
            return emptyECP;
        }
        int currentCPCount = clazz.getCurrentCPoolCount();
        DynamicConstantPoolExtension ecp = DynamicConstantPoolExtension.newDynamicCPExtension(clazz, injType, currentCPCount);
        clazz.setBaseCPoolCount(injType, currentCPCount);
        clazz.setCurrentCPoolCount(currentCPCount + ecp.nAddedEntries);
        return ecp;
    }

    public static DynamicConstantPoolExtension getEmptyCPFragment() {
        return emptyECP;
    }

    protected static DynamicConstantPoolExtension newDynamicCPExtension(DynamicClassInfo clazz, int injectionType, int baseCPCount) {
        int secondaryCPCount = 0;
        switch (injectionType) {
            case 1: 
            case 2: {
                secondaryCPCount = clazz.getBaseCPoolCount(0);
                break;
            }
            case 4: 
            case 5: {
                secondaryCPCount = clazz.getBaseCPoolCount(3);
            }
        }
        return new DynamicConstantPoolExtension(clazz, injectionType, baseCPCount, secondaryCPCount);
    }
}

