/*
 * Decompiled with CFR 0.152.
 */
package jakarta.batch.runtime;

import jakarta.batch.operations.JobOperator;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BatchRuntime {
    private static final String sourceClass = BatchRuntime.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);

    public static JobOperator getJobOperator() {
        JobOperator operator = null;
        if (System.getSecurityManager() == null) {
            Iterator<JobOperator> iterator = ServiceLoader.load(JobOperator.class).iterator();
            if (iterator.hasNext()) {
                JobOperator provider = iterator.next();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Loaded JobOperator with class: " + provider.getClass().getCanonicalName());
                }
                operator = provider;
            }
        } else {
            operator = AccessController.doPrivileged(new PrivilegedAction<JobOperator>(){

                @Override
                public JobOperator run() {
                    JobOperator returnVal;
                    block1: {
                        ServiceLoader<JobOperator> loader = ServiceLoader.load(JobOperator.class);
                        returnVal = null;
                        Iterator<JobOperator> iterator = loader.iterator();
                        if (!iterator.hasNext()) break block1;
                        JobOperator provider = iterator.next();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Loaded JobOperator with class: " + provider.getClass().getCanonicalName());
                        }
                        returnVal = provider;
                    }
                    return returnVal;
                }
            });
        }
        if (operator == null && logger.isLoggable(Level.WARNING)) {
            logger.warning("The ServiceLoader was unable to find an implementation for JobOperator. Check classpath for META-INF/services/jakarta.batch.operations.JobOperator file.");
        }
        return operator;
    }
}

