/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lsp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.openide.util.Parameters;

public final class ResourceModificationException
extends Exception {
    private final List<WorkspaceEdit> appliedEdits;
    private final WorkspaceEdit failedEdit;
    private final int failedOperationIndex;
    private final List<String> savedResources;
    private final int failedEditIndex;
    public static final int BEFORE_FIRST_EDIT = -1;
    public static final int UNSPECIFIED_EDIT = -2;
    public static final int UNSPECIFIED_OPERATIION = -2;

    public ResourceModificationException(List<WorkspaceEdit> appliedEdits, WorkspaceEdit failedEdit, int failedOperationIndex, int failedEditIndex, Collection<String> savedResources, String message, Throwable cause) {
        super(message, cause);
        Parameters.notNull((CharSequence)"appliedEdits", appliedEdits);
        this.appliedEdits = appliedEdits;
        this.failedEdit = failedEdit;
        this.savedResources = savedResources == null ? Collections.emptyList() : new ArrayList<String>(savedResources);
        this.failedOperationIndex = failedOperationIndex;
        this.failedEditIndex = failedEditIndex;
    }

    public ResourceModificationException(List<WorkspaceEdit> appliedEdits, List<String> savedResources, String message) {
        super(message);
        Parameters.notNull((CharSequence)"appliedEdits", appliedEdits);
        Parameters.notNull((CharSequence)"savedResources", savedResources);
        this.appliedEdits = appliedEdits;
        this.failedEdit = null;
        this.failedOperationIndex = -2;
        this.failedEditIndex = -2;
        this.savedResources = savedResources;
    }

    public int getFailedEditIndex() {
        return this.failedEditIndex;
    }

    public boolean isUnspecifiedEdit() {
        return this.failedOperationIndex >= 0 && this.failedEditIndex != -2;
    }

    @NonNull
    public List<WorkspaceEdit> getAppliedEdits() {
        return this.appliedEdits;
    }

    @CheckForNull
    public WorkspaceEdit getFailedEdit() {
        return this.failedEdit;
    }

    public int getFailedOperationIndex() {
        return this.failedOperationIndex;
    }

    @NonNull
    public List<String> getSavedResources() {
        return this.savedResources;
    }
}

