/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.completion;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.micronaut.MicronautConfigProperties;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;

public class MicronautConfigCompletionTask {
    public <T> List<T> query(Document doc, int caretOffset, final Project project, final ItemFactory<T> factory) {
        final ArrayList<T> items = new ArrayList<T>();
        final LineDocument lineDocument = (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class);
        if (lineDocument != null) {
            int lineStart = LineDocumentUtils.getLineStart((LineDocument)lineDocument, (int)caretOffset);
            try {
                String text = lineDocument.getText(lineStart, caretOffset - lineStart);
                String mimeType = DocumentUtilities.getMimeType((Document)doc);
                if ("text/x-yaml".equals(mimeType)) {
                    if (!text.startsWith("#")) {
                        int idx = text.indexOf(58);
                        if (idx < 0) {
                            final int lineIndent = Math.min(IndentUtils.lineIndent((Document)lineDocument, (int)lineStart), caretOffset - lineStart);
                            final int wordStart = LineDocumentUtils.getPreviousWhitespace((LineDocument)lineDocument, (int)caretOffset) + 1;
                            final String prefix = wordStart < caretOffset ? text.substring(wordStart - lineStart) : null;
                            final int anchorOffset = wordStart < caretOffset ? wordStart : caretOffset;
                            ParserManager.parse(Collections.singleton(Source.create((Document)lineDocument)), (UserTask)new UserTask(){

                                public void run(ResultIterator resultIterator) throws Exception {
                                    StructureScanner scanner;
                                    Language language;
                                    Parser.Result r = resultIterator.getParserResult();
                                    if (r instanceof ParserResult && (language = LanguageRegistry.getInstance().getLanguageByMimeType(resultIterator.getSnapshot().getMimeType())) != null && (scanner = language.getStructure()) != null) {
                                        List structures = scanner.scan((ParserResult)r);
                                        int indentLevelSize = MicronautConfigCompletionTask.this.getIndentLevelSize(lineDocument, structures);
                                        List context = MicronautConfigCompletionTask.this.getContext(structures, wordStart);
                                        String filter = "";
                                        StructureItem currentItem = null;
                                        for (StructureItem item : context) {
                                            int itemLineStart = LineDocumentUtils.getLineStart((LineDocument)lineDocument, (int)((int)item.getPosition()));
                                            int itemLineIndent = IndentUtils.lineIndent((Document)lineDocument, (int)itemLineStart);
                                            if (itemLineIndent >= lineIndent) continue;
                                            filter = filter + item.getName() + '.';
                                            currentItem = item;
                                        }
                                        if (prefix != null) {
                                            filter = filter + prefix;
                                        }
                                        int currentItemLineIndent = currentItem != null ? IndentUtils.lineIndent((Document)lineDocument, (int)LineDocumentUtils.getLineStart((LineDocument)lineDocument, (int)((int)currentItem.getPosition()))) : -indentLevelSize;
                                        Map<String, ConfigurationMetadataProperty> properties = MicronautConfigProperties.getProperties(project);
                                        HashSet<String> topLevels = new HashSet<String>();
                                        for (Map.Entry<String, ConfigurationMetadataProperty> entry : properties.entrySet()) {
                                            int dotIdx;
                                            String simpleName;
                                            String propName = entry.getKey();
                                            int idx = MicronautConfigCompletionTask.this.match(propName, filter);
                                            if (idx < 0 || !MicronautConfigCompletionTask.this.filter(currentItem != null ? currentItem.getNestedItems() : structures, simpleName = (dotIdx = propName.indexOf(46, idx)) < 0 ? propName.substring(idx) : propName.substring(idx, dotIdx))) continue;
                                            items.add(factory.createPropertyItem(entry.getValue(), anchorOffset, currentItemLineIndent + indentLevelSize, indentLevelSize, idx));
                                            if (dotIdx <= 0) continue;
                                            topLevels.add(simpleName);
                                        }
                                        for (String topLevel : topLevels) {
                                            items.add(factory.createTopLevelPropertyItem(topLevel, anchorOffset, currentItemLineIndent + indentLevelSize, indentLevelSize));
                                        }
                                    }
                                }
                            });
                        } else {
                            int prevWS = LineDocumentUtils.getPreviousWhitespace((LineDocument)lineDocument, (int)caretOffset);
                            final int wordStart = (prevWS < lineStart + idx ? lineStart + idx : prevWS) + 1;
                            final String prefix = wordStart < caretOffset ? text.substring(wordStart - lineStart) : "";
                            final int anchorOffset = wordStart < caretOffset ? wordStart : caretOffset;
                            ParserManager.parse(Collections.singleton(Source.create((Document)lineDocument)), (UserTask)new UserTask(){

                                public void run(ResultIterator resultIterator) throws Exception {
                                    StructureScanner scanner;
                                    Language language;
                                    Parser.Result r = resultIterator.getParserResult();
                                    if (r instanceof ParserResult && (language = LanguageRegistry.getInstance().getLanguageByMimeType(resultIterator.getSnapshot().getMimeType())) != null && (scanner = language.getStructure()) != null) {
                                        List structures = scanner.scan((ParserResult)r);
                                        List context = MicronautConfigCompletionTask.this.getContext(structures, wordStart);
                                        String propName = "";
                                        for (StructureItem structureItem : context) {
                                            propName = propName + (propName.isEmpty() ? structureItem.getName() : '.' + structureItem.getName());
                                        }
                                        if (!propName.isEmpty()) {
                                            items.addAll(MicronautConfigCompletionTask.this.completeValues(propName, prefix, anchorOffset, project, factory));
                                        }
                                    }
                                }
                            });
                        }
                    }
                } else if (!text.startsWith("#") && !text.startsWith("!")) {
                    int colIdx = text.indexOf(58);
                    int eqIdx = text.indexOf(61);
                    if (colIdx < 0) {
                        if (eqIdx < 0) {
                            int wordStart = LineDocumentUtils.getPreviousWhitespace((LineDocument)lineDocument, (int)caretOffset) + 1;
                            String prefix = wordStart < caretOffset ? text.substring(wordStart - lineStart) : "";
                            int lastDotIdx = prefix.lastIndexOf(46);
                            int anchorOffset = wordStart < caretOffset ? wordStart + (lastDotIdx < 0 ? 0 : lastDotIdx + 1) : caretOffset;
                            Properties props = new Properties();
                            props.load(new StringReader(doc.getText(0, doc.getLength())));
                            Map<String, ConfigurationMetadataProperty> properties = MicronautConfigProperties.getProperties(project);
                            HashSet<String> topLevels = new HashSet<String>();
                            for (Map.Entry<String, ConfigurationMetadataProperty> entry : properties.entrySet()) {
                                String simpleName;
                                String propName = entry.getKey();
                                int idx = this.match(propName, prefix);
                                if (idx < 0) continue;
                                int dotIdx = propName.indexOf(46, idx);
                                String string = simpleName = dotIdx < 0 ? propName.substring(idx) : propName.substring(idx, dotIdx);
                                if (props.getProperty(propName) != null) continue;
                                items.add(factory.createPropertyItem(entry.getValue(), anchorOffset, -1, -1, idx));
                                if (dotIdx <= 0) continue;
                                topLevels.add(simpleName);
                            }
                            for (String topLevel : topLevels) {
                                items.add(factory.createTopLevelPropertyItem(topLevel, anchorOffset, -1, -1));
                            }
                        } else {
                            int wordStart = LineDocumentUtils.getPreviousWhitespace((LineDocument)lineDocument, (int)caretOffset) + 1;
                            if (wordStart < lineStart + eqIdx) {
                                wordStart = lineStart + eqIdx + 1;
                            }
                            String prefix = wordStart < caretOffset ? text.substring(wordStart - lineStart) : "";
                            int anchorOffset = wordStart < caretOffset ? wordStart : caretOffset;
                            String propName = text.substring(0, eqIdx).trim();
                            if (!propName.isEmpty()) {
                                items.addAll(this.completeValues(propName, prefix, anchorOffset, project, factory));
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return items;
    }

    private <T> List<T> completeValues(String propName, String prefix, int anchorOffset, Project project, ItemFactory<T> factory) {
        String type;
        ArrayList items = new ArrayList();
        Map<String, ConfigurationMetadataProperty> properties = MicronautConfigProperties.getProperties(project);
        ConfigurationMetadataProperty property = properties.get(propName);
        if (property != null && (type = property.getType()) != null) {
            if ("boolean".equals(type)) {
                if ("true".startsWith(prefix)) {
                    items.add(factory.createValueItem("true", anchorOffset, false));
                }
                if ("false".startsWith(prefix)) {
                    items.add(factory.createValueItem("false", anchorOffset, false));
                }
            } else {
                SourceGroup[] srcGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
                AtomicBoolean resolved = new AtomicBoolean();
                for (SourceGroup srcGroup : srcGroups) {
                    JavaSource js;
                    if (resolved.get() || (js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)srcGroup.getRootFolder()), (FileObject[])new FileObject[0])) == null) continue;
                    try {
                        js.runUserActionTask(cc -> {
                            cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            TypeElement typeElement = cc.getElements().getTypeElement(type);
                            if (typeElement != null) {
                                resolved.set(true);
                                if (typeElement.getKind() == ElementKind.ENUM) {
                                    for (Element element : typeElement.getEnclosedElements()) {
                                        String name;
                                        if (element.getKind() != ElementKind.ENUM_CONSTANT || !(name = element.getSimpleName().toString()).startsWith(prefix)) continue;
                                        items.add(factory.createValueItem(name, anchorOffset, true));
                                    }
                                }
                            }
                        }, true);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return items;
    }

    private int match(String propName, String filter) {
        int len = 0;
        String[] parts = propName.split("\\*");
        for (int i = 0; i < parts.length; ++i) {
            int idx;
            String part = parts[i];
            if (filter.length() <= part.length()) {
                if (part.startsWith(filter)) {
                    idx = filter.lastIndexOf(46);
                    return idx < 0 ? len : len + idx + 1;
                }
                return -1;
            }
            if (i < parts.length - 1) {
                if (!part.equals(filter.substring(0, part.length()))) {
                    return -1;
                }
                len += part.length();
                idx = filter.indexOf(46, part.length());
                if (idx < 0) {
                    return -1;
                }
                ++len;
            } else {
                return filter.startsWith(part) ? len : -1;
            }
            filter = filter.substring(idx);
        }
        return -1;
    }

    private boolean filter(List<? extends StructureItem> structures, String name) {
        for (StructureItem structureItem : structures) {
            if (!name.equals(structureItem.getName())) continue;
            return false;
        }
        return true;
    }

    private List<StructureItem> getContext(List<? extends StructureItem> structure, int offset) {
        ArrayList<StructureItem> items = new ArrayList<StructureItem>();
        while (structure != null && !structure.isEmpty()) {
            StructureItem currentItem = null;
            for (StructureItem item : structure) {
                if (item.getPosition() >= (long)offset) continue;
                currentItem = item;
            }
            if (currentItem != null) {
                items.add(currentItem);
                structure = currentItem.getNestedItems();
                continue;
            }
            structure = null;
        }
        return items;
    }

    private int getIndentLevelSize(LineDocument lineDocument, List<? extends StructureItem> structures) {
        int indentLevel = IndentUtils.indentLevelSize((Document)lineDocument);
        try {
            for (StructureItem structureItem : structures) {
                int baseStart = LineDocumentUtils.getLineStart((LineDocument)lineDocument, (int)((int)structureItem.getPosition()));
                int baseIndent = IndentUtils.lineIndent((Document)lineDocument, (int)baseStart);
                for (StructureItem nestedItem : structureItem.getNestedItems()) {
                    int lineStart = LineDocumentUtils.getLineStart((LineDocument)lineDocument, (int)((int)nestedItem.getPosition()));
                    int lineIndent = IndentUtils.lineIndent((Document)lineDocument, (int)lineStart) - baseIndent;
                    if (lineIndent <= 0 || lineIndent >= indentLevel) continue;
                    indentLevel = lineIndent;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return indentLevel;
    }

    public static interface ItemFactory<T> {
        public T createTopLevelPropertyItem(String var1, int var2, int var3, int var4);

        public T createPropertyItem(ConfigurationMetadataProperty var1, int var2, int var3, int var4, int var5);

        public T createValueItem(String var1, int var2, boolean var3);
    }
}

