// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2/participant.proto

package dialogflowpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Participants_CreateParticipant_FullMethodName       = "/google.cloud.dialogflow.v2.Participants/CreateParticipant"
	Participants_GetParticipant_FullMethodName          = "/google.cloud.dialogflow.v2.Participants/GetParticipant"
	Participants_ListParticipants_FullMethodName        = "/google.cloud.dialogflow.v2.Participants/ListParticipants"
	Participants_UpdateParticipant_FullMethodName       = "/google.cloud.dialogflow.v2.Participants/UpdateParticipant"
	Participants_AnalyzeContent_FullMethodName          = "/google.cloud.dialogflow.v2.Participants/AnalyzeContent"
	Participants_StreamingAnalyzeContent_FullMethodName = "/google.cloud.dialogflow.v2.Participants/StreamingAnalyzeContent"
	Participants_SuggestArticles_FullMethodName         = "/google.cloud.dialogflow.v2.Participants/SuggestArticles"
	Participants_SuggestFaqAnswers_FullMethodName       = "/google.cloud.dialogflow.v2.Participants/SuggestFaqAnswers"
	Participants_SuggestSmartReplies_FullMethodName     = "/google.cloud.dialogflow.v2.Participants/SuggestSmartReplies"
	Participants_SuggestKnowledgeAssist_FullMethodName  = "/google.cloud.dialogflow.v2.Participants/SuggestKnowledgeAssist"
)

// ParticipantsClient is the client API for Participants service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ParticipantsClient interface {
	// Creates a new participant in a conversation.
	CreateParticipant(ctx context.Context, in *CreateParticipantRequest, opts ...grpc.CallOption) (*Participant, error)
	// Retrieves a conversation participant.
	GetParticipant(ctx context.Context, in *GetParticipantRequest, opts ...grpc.CallOption) (*Participant, error)
	// Returns the list of all participants in the specified conversation.
	ListParticipants(ctx context.Context, in *ListParticipantsRequest, opts ...grpc.CallOption) (*ListParticipantsResponse, error)
	// Updates the specified participant.
	UpdateParticipant(ctx context.Context, in *UpdateParticipantRequest, opts ...grpc.CallOption) (*Participant, error)
	// Adds a text (chat, for example), or audio (phone recording, for example)
	// message from a participant into the conversation.
	//
	// Note: Always use agent versions for production traffic
	// sent to virtual agents. See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	AnalyzeContent(ctx context.Context, in *AnalyzeContentRequest, opts ...grpc.CallOption) (*AnalyzeContentResponse, error)
	// Adds a text (chat, for example), or audio (phone recording, for example)
	// message from a participant into the conversation.
	// Note: This method is only available through the gRPC API (not REST).
	//
	// The top-level message sent to the client by the server is
	// `StreamingAnalyzeContentResponse`. Multiple response messages can be
	// returned in order. The first one or more messages contain the
	// `recognition_result` field. Each result represents a more complete
	// transcript of what the user said. The next message contains the
	// `reply_text` field and potentially the `reply_audio` field. The message can
	// also contain the `automated_agent_reply` field.
	//
	// Note: Always use agent versions for production traffic
	// sent to virtual agents. See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	StreamingAnalyzeContent(ctx context.Context, opts ...grpc.CallOption) (Participants_StreamingAnalyzeContentClient, error)
	// Gets suggested articles for a participant based on specific historical
	// messages.
	SuggestArticles(ctx context.Context, in *SuggestArticlesRequest, opts ...grpc.CallOption) (*SuggestArticlesResponse, error)
	// Gets suggested faq answers for a participant based on specific historical
	// messages.
	SuggestFaqAnswers(ctx context.Context, in *SuggestFaqAnswersRequest, opts ...grpc.CallOption) (*SuggestFaqAnswersResponse, error)
	// Gets smart replies for a participant based on specific historical
	// messages.
	SuggestSmartReplies(ctx context.Context, in *SuggestSmartRepliesRequest, opts ...grpc.CallOption) (*SuggestSmartRepliesResponse, error)
	// Gets knowledge assist suggestions based on historical messages.
	SuggestKnowledgeAssist(ctx context.Context, in *SuggestKnowledgeAssistRequest, opts ...grpc.CallOption) (*SuggestKnowledgeAssistResponse, error)
}

type participantsClient struct {
	cc grpc.ClientConnInterface
}

func NewParticipantsClient(cc grpc.ClientConnInterface) ParticipantsClient {
	return &participantsClient{cc}
}

func (c *participantsClient) CreateParticipant(ctx context.Context, in *CreateParticipantRequest, opts ...grpc.CallOption) (*Participant, error) {
	out := new(Participant)
	err := c.cc.Invoke(ctx, Participants_CreateParticipant_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) GetParticipant(ctx context.Context, in *GetParticipantRequest, opts ...grpc.CallOption) (*Participant, error) {
	out := new(Participant)
	err := c.cc.Invoke(ctx, Participants_GetParticipant_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) ListParticipants(ctx context.Context, in *ListParticipantsRequest, opts ...grpc.CallOption) (*ListParticipantsResponse, error) {
	out := new(ListParticipantsResponse)
	err := c.cc.Invoke(ctx, Participants_ListParticipants_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) UpdateParticipant(ctx context.Context, in *UpdateParticipantRequest, opts ...grpc.CallOption) (*Participant, error) {
	out := new(Participant)
	err := c.cc.Invoke(ctx, Participants_UpdateParticipant_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) AnalyzeContent(ctx context.Context, in *AnalyzeContentRequest, opts ...grpc.CallOption) (*AnalyzeContentResponse, error) {
	out := new(AnalyzeContentResponse)
	err := c.cc.Invoke(ctx, Participants_AnalyzeContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) StreamingAnalyzeContent(ctx context.Context, opts ...grpc.CallOption) (Participants_StreamingAnalyzeContentClient, error) {
	stream, err := c.cc.NewStream(ctx, &Participants_ServiceDesc.Streams[0], Participants_StreamingAnalyzeContent_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &participantsStreamingAnalyzeContentClient{stream}
	return x, nil
}

type Participants_StreamingAnalyzeContentClient interface {
	Send(*StreamingAnalyzeContentRequest) error
	Recv() (*StreamingAnalyzeContentResponse, error)
	grpc.ClientStream
}

type participantsStreamingAnalyzeContentClient struct {
	grpc.ClientStream
}

func (x *participantsStreamingAnalyzeContentClient) Send(m *StreamingAnalyzeContentRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *participantsStreamingAnalyzeContentClient) Recv() (*StreamingAnalyzeContentResponse, error) {
	m := new(StreamingAnalyzeContentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *participantsClient) SuggestArticles(ctx context.Context, in *SuggestArticlesRequest, opts ...grpc.CallOption) (*SuggestArticlesResponse, error) {
	out := new(SuggestArticlesResponse)
	err := c.cc.Invoke(ctx, Participants_SuggestArticles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) SuggestFaqAnswers(ctx context.Context, in *SuggestFaqAnswersRequest, opts ...grpc.CallOption) (*SuggestFaqAnswersResponse, error) {
	out := new(SuggestFaqAnswersResponse)
	err := c.cc.Invoke(ctx, Participants_SuggestFaqAnswers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) SuggestSmartReplies(ctx context.Context, in *SuggestSmartRepliesRequest, opts ...grpc.CallOption) (*SuggestSmartRepliesResponse, error) {
	out := new(SuggestSmartRepliesResponse)
	err := c.cc.Invoke(ctx, Participants_SuggestSmartReplies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) SuggestKnowledgeAssist(ctx context.Context, in *SuggestKnowledgeAssistRequest, opts ...grpc.CallOption) (*SuggestKnowledgeAssistResponse, error) {
	out := new(SuggestKnowledgeAssistResponse)
	err := c.cc.Invoke(ctx, Participants_SuggestKnowledgeAssist_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ParticipantsServer is the server API for Participants service.
// All implementations should embed UnimplementedParticipantsServer
// for forward compatibility
type ParticipantsServer interface {
	// Creates a new participant in a conversation.
	CreateParticipant(context.Context, *CreateParticipantRequest) (*Participant, error)
	// Retrieves a conversation participant.
	GetParticipant(context.Context, *GetParticipantRequest) (*Participant, error)
	// Returns the list of all participants in the specified conversation.
	ListParticipants(context.Context, *ListParticipantsRequest) (*ListParticipantsResponse, error)
	// Updates the specified participant.
	UpdateParticipant(context.Context, *UpdateParticipantRequest) (*Participant, error)
	// Adds a text (chat, for example), or audio (phone recording, for example)
	// message from a participant into the conversation.
	//
	// Note: Always use agent versions for production traffic
	// sent to virtual agents. See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	AnalyzeContent(context.Context, *AnalyzeContentRequest) (*AnalyzeContentResponse, error)
	// Adds a text (chat, for example), or audio (phone recording, for example)
	// message from a participant into the conversation.
	// Note: This method is only available through the gRPC API (not REST).
	//
	// The top-level message sent to the client by the server is
	// `StreamingAnalyzeContentResponse`. Multiple response messages can be
	// returned in order. The first one or more messages contain the
	// `recognition_result` field. Each result represents a more complete
	// transcript of what the user said. The next message contains the
	// `reply_text` field and potentially the `reply_audio` field. The message can
	// also contain the `automated_agent_reply` field.
	//
	// Note: Always use agent versions for production traffic
	// sent to virtual agents. See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	StreamingAnalyzeContent(Participants_StreamingAnalyzeContentServer) error
	// Gets suggested articles for a participant based on specific historical
	// messages.
	SuggestArticles(context.Context, *SuggestArticlesRequest) (*SuggestArticlesResponse, error)
	// Gets suggested faq answers for a participant based on specific historical
	// messages.
	SuggestFaqAnswers(context.Context, *SuggestFaqAnswersRequest) (*SuggestFaqAnswersResponse, error)
	// Gets smart replies for a participant based on specific historical
	// messages.
	SuggestSmartReplies(context.Context, *SuggestSmartRepliesRequest) (*SuggestSmartRepliesResponse, error)
	// Gets knowledge assist suggestions based on historical messages.
	SuggestKnowledgeAssist(context.Context, *SuggestKnowledgeAssistRequest) (*SuggestKnowledgeAssistResponse, error)
}

// UnimplementedParticipantsServer should be embedded to have forward compatible implementations.
type UnimplementedParticipantsServer struct {
}

func (UnimplementedParticipantsServer) CreateParticipant(context.Context, *CreateParticipantRequest) (*Participant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateParticipant not implemented")
}
func (UnimplementedParticipantsServer) GetParticipant(context.Context, *GetParticipantRequest) (*Participant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetParticipant not implemented")
}
func (UnimplementedParticipantsServer) ListParticipants(context.Context, *ListParticipantsRequest) (*ListParticipantsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListParticipants not implemented")
}
func (UnimplementedParticipantsServer) UpdateParticipant(context.Context, *UpdateParticipantRequest) (*Participant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateParticipant not implemented")
}
func (UnimplementedParticipantsServer) AnalyzeContent(context.Context, *AnalyzeContentRequest) (*AnalyzeContentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeContent not implemented")
}
func (UnimplementedParticipantsServer) StreamingAnalyzeContent(Participants_StreamingAnalyzeContentServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingAnalyzeContent not implemented")
}
func (UnimplementedParticipantsServer) SuggestArticles(context.Context, *SuggestArticlesRequest) (*SuggestArticlesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SuggestArticles not implemented")
}
func (UnimplementedParticipantsServer) SuggestFaqAnswers(context.Context, *SuggestFaqAnswersRequest) (*SuggestFaqAnswersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SuggestFaqAnswers not implemented")
}
func (UnimplementedParticipantsServer) SuggestSmartReplies(context.Context, *SuggestSmartRepliesRequest) (*SuggestSmartRepliesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SuggestSmartReplies not implemented")
}
func (UnimplementedParticipantsServer) SuggestKnowledgeAssist(context.Context, *SuggestKnowledgeAssistRequest) (*SuggestKnowledgeAssistResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SuggestKnowledgeAssist not implemented")
}

// UnsafeParticipantsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ParticipantsServer will
// result in compilation errors.
type UnsafeParticipantsServer interface {
	mustEmbedUnimplementedParticipantsServer()
}

func RegisterParticipantsServer(s grpc.ServiceRegistrar, srv ParticipantsServer) {
	s.RegisterService(&Participants_ServiceDesc, srv)
}

func _Participants_CreateParticipant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateParticipantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).CreateParticipant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Participants_CreateParticipant_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).CreateParticipant(ctx, req.(*CreateParticipantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_GetParticipant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetParticipantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).GetParticipant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Participants_GetParticipant_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).GetParticipant(ctx, req.(*GetParticipantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_ListParticipants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListParticipantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).ListParticipants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Participants_ListParticipants_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).ListParticipants(ctx, req.(*ListParticipantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_UpdateParticipant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateParticipantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).UpdateParticipant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Participants_UpdateParticipant_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).UpdateParticipant(ctx, req.(*UpdateParticipantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_AnalyzeContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).AnalyzeContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Participants_AnalyzeContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).AnalyzeContent(ctx, req.(*AnalyzeContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_StreamingAnalyzeContent_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ParticipantsServer).StreamingAnalyzeContent(&participantsStreamingAnalyzeContentServer{stream})
}

type Participants_StreamingAnalyzeContentServer interface {
	Send(*StreamingAnalyzeContentResponse) error
	Recv() (*StreamingAnalyzeContentRequest, error)
	grpc.ServerStream
}

type participantsStreamingAnalyzeContentServer struct {
	grpc.ServerStream
}

func (x *participantsStreamingAnalyzeContentServer) Send(m *StreamingAnalyzeContentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *participantsStreamingAnalyzeContentServer) Recv() (*StreamingAnalyzeContentRequest, error) {
	m := new(StreamingAnalyzeContentRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Participants_SuggestArticles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuggestArticlesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).SuggestArticles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Participants_SuggestArticles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).SuggestArticles(ctx, req.(*SuggestArticlesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_SuggestFaqAnswers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuggestFaqAnswersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).SuggestFaqAnswers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Participants_SuggestFaqAnswers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).SuggestFaqAnswers(ctx, req.(*SuggestFaqAnswersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_SuggestSmartReplies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuggestSmartRepliesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).SuggestSmartReplies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Participants_SuggestSmartReplies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).SuggestSmartReplies(ctx, req.(*SuggestSmartRepliesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_SuggestKnowledgeAssist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuggestKnowledgeAssistRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).SuggestKnowledgeAssist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Participants_SuggestKnowledgeAssist_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).SuggestKnowledgeAssist(ctx, req.(*SuggestKnowledgeAssistRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Participants_ServiceDesc is the grpc.ServiceDesc for Participants service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Participants_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Participants",
	HandlerType: (*ParticipantsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateParticipant",
			Handler:    _Participants_CreateParticipant_Handler,
		},
		{
			MethodName: "GetParticipant",
			Handler:    _Participants_GetParticipant_Handler,
		},
		{
			MethodName: "ListParticipants",
			Handler:    _Participants_ListParticipants_Handler,
		},
		{
			MethodName: "UpdateParticipant",
			Handler:    _Participants_UpdateParticipant_Handler,
		},
		{
			MethodName: "AnalyzeContent",
			Handler:    _Participants_AnalyzeContent_Handler,
		},
		{
			MethodName: "SuggestArticles",
			Handler:    _Participants_SuggestArticles_Handler,
		},
		{
			MethodName: "SuggestFaqAnswers",
			Handler:    _Participants_SuggestFaqAnswers_Handler,
		},
		{
			MethodName: "SuggestSmartReplies",
			Handler:    _Participants_SuggestSmartReplies_Handler,
		},
		{
			MethodName: "SuggestKnowledgeAssist",
			Handler:    _Participants_SuggestKnowledgeAssist_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingAnalyzeContent",
			Handler:       _Participants_StreamingAnalyzeContent_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/dialogflow/v2/participant.proto",
}
