/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.traccar.helper.model.DeviceUtil;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.reports.common.ReportUtils;
import org.traccar.reports.model.BaseReportItem;
import org.traccar.reports.model.GeofenceReportItem;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Order;
import org.traccar.storage.query.Request;

public class GeofenceReportProvider {
    private final ReportUtils reportUtils;
    private final Storage storage;

    @Inject
    public GeofenceReportProvider(ReportUtils reportUtils, Storage storage) {
        this.reportUtils = reportUtils;
        this.storage = storage;
    }

    private Collection<Event> getEvents(long deviceId, Date from, Date to) throws StorageException {
        return this.storage.getObjects(Event.class, new Request(new Columns.All(), new Condition.And(new Condition.Equals("deviceId", deviceId), new Condition.And(new Condition.Between("eventTime", from, to), new Condition.Or(new Condition.Equals("type", "geofenceEnter"), new Condition.Equals("type", "geofenceExit")))), new Order("eventTime")));
    }

    public Collection<GeofenceReportItem> getObjects(long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Collection<Long> geofenceIds, Date from, Date to) throws StorageException {
        this.reportUtils.checkPeriodLimit(from, to);
        ArrayList<GeofenceReportItem> result = new ArrayList<GeofenceReportItem>();
        for (Device device : DeviceUtil.getAccessibleDevices(this.storage, userId, deviceIds, groupIds)) {
            HashMap<Long, Event> openEvents = new HashMap<Long, Event>();
            for (Event event : this.getEvents(device.getId(), from, to)) {
                Event enterEvent;
                long geofenceId = event.getGeofenceId();
                if (!geofenceIds.contains(geofenceId)) continue;
                if ("geofenceEnter".equals(event.getType())) {
                    openEvents.put(geofenceId, event);
                    continue;
                }
                if (!"geofenceExit".equals(event.getType()) || (enterEvent = (Event)openEvents.remove(geofenceId)) == null || event.getEventTime().before(enterEvent.getEventTime())) continue;
                GeofenceReportItem item = new GeofenceReportItem();
                item.setDeviceId(device.getId());
                item.setDeviceName(device.getName());
                item.setGeofenceId(geofenceId);
                item.setStartTime(enterEvent.getEventTime());
                item.setEndTime(event.getEventTime());
                result.add(item);
            }
        }
        result.sort(Comparator.comparing(BaseReportItem::getStartTime));
        return result;
    }
}

