/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class RecodaProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_HEARTBEAT = 4097;
    public static final int MSG_REQUEST_RESPONSE = 0x20000001;
    public static final int MSG_SIGNAL_LINK_REGISTRATION = 0x20001001;
    public static final int MSG_EVENT_NOTICE = 0x20002001;
    public static final int MSG_GPS_DATA = 0x20001011;

    public RecodaProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int type = buf.readIntLE();
        buf.readUnsignedIntLE();
        if (type != 4097) {
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
        }
        if (type == 0x20001001) {
            this.getDeviceSession(channel, remoteAddress, buf.readSlice(12).toString(StandardCharsets.US_ASCII));
        } else if (type == 0x20001011) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setTime(new Date(buf.readLongLE()));
            short flags = buf.readUnsignedByte();
            if (BitUtil.check(flags, 0)) {
                buf.readUnsignedShortLE();
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShortLE()));
                position.setLongitude((double)buf.readUnsignedByte() + (double)buf.readUnsignedByte() / 60.0);
                position.setLatitude((double)buf.readUnsignedByte() + (double)buf.readUnsignedByte() / 60.0);
                position.setLongitude(position.getLongitude() + (double)buf.readUnsignedIntLE() / 3600.0);
                position.setLatitude(position.getLatitude() + (double)buf.readUnsignedIntLE() / 3600.0);
                short status = buf.readUnsignedByte();
                position.setValid(BitUtil.check(status, 0));
                if (BitUtil.check(status, 1)) {
                    position.setLongitude(-position.getLongitude());
                }
                if (!BitUtil.check(status, 2)) {
                    position.setLatitude(-position.getLatitude());
                }
            } else {
                this.getLastLocation(position, position.getDeviceTime());
            }
            return position;
        }
        return null;
    }
}

