/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search.hybrid;

import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.search.SearchProtocol;
import redis.clients.jedis.util.JedisAsserts;

@Experimental
public class FTHybridVectorParams
implements IParams {
    private String field;
    private String vector;
    private VectorMethod method;
    private final List<String> filters = new ArrayList<String>();
    private String scoreAlias;

    private FTHybridVectorParams() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void addParams(CommandArguments args) {
        args.add(SearchProtocol.SearchKeyword.VSIM);
        args.add(this.field);
        if (this.vector.startsWith("$")) {
            args.add(this.vector);
        } else {
            args.add(String.format("$%s", this.vector));
        }
        this.method.addParams(args);
        for (String filter : this.filters) {
            args.add(SearchProtocol.SearchKeyword.FILTER);
            args.add(filter);
        }
        if (this.scoreAlias != null) {
            args.add(SearchProtocol.SearchKeyword.YIELD_SCORE_AS);
            args.add(this.scoreAlias);
        }
    }

    public static class Range
    implements VectorMethod {
        private final double radius;
        private Double epsilon;

        private Range(double radius) {
            this.radius = radius;
        }

        public static Range of(double radius) {
            return new Range(radius);
        }

        public Range epsilon(double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        @Override
        public void addParams(CommandArguments args) {
            args.add(SearchProtocol.SearchKeyword.RANGE);
            int paramCount = this.epsilon != null ? 4 : 2;
            args.add(paramCount);
            args.add(SearchProtocol.SearchKeyword.RADIUS);
            args.add(this.radius);
            if (this.epsilon != null) {
                args.add(SearchProtocol.SearchKeyword.EPSILON);
                args.add(this.epsilon);
            }
        }
    }

    public static class Knn
    implements VectorMethod {
        private final int k;
        private Integer efRuntime;

        private Knn(int k) {
            this.k = k;
        }

        public static Knn of(int k) {
            return new Knn(k);
        }

        public Knn efRuntime(int efRuntime) {
            this.efRuntime = efRuntime;
            return this;
        }

        @Override
        public void addParams(CommandArguments args) {
            args.add(SearchProtocol.SearchKeyword.KNN);
            int paramCount = this.efRuntime != null ? 4 : 2;
            args.add(paramCount);
            args.add(SearchProtocol.SearchKeyword.K);
            args.add(this.k);
            if (this.efRuntime != null) {
                args.add(SearchProtocol.SearchKeyword.EF_RUNTIME);
                args.add(this.efRuntime);
            }
        }
    }

    public static interface VectorMethod
    extends IParams {
    }

    public static class Builder {
        private final FTHybridVectorParams instance = new FTHybridVectorParams();

        public FTHybridVectorParams build() {
            JedisAsserts.notNull(this.instance.field, "Field is required for VSIM clause");
            JedisAsserts.notNull(this.instance.vector, "Vector is required for VSIM clause");
            JedisAsserts.notNull(this.instance.method, "Method (KNN or RANGE) is required for VSIM clause");
            return this.instance;
        }

        public Builder field(String field) {
            this.instance.field = field;
            return this;
        }

        public Builder vector(String vector) {
            this.instance.vector = vector;
            return this;
        }

        public Builder method(VectorMethod method) {
            this.instance.method = method;
            return this;
        }

        public Builder filter(String filter) {
            JedisAsserts.notNull(filter, "Filter expression must not be null");
            this.instance.filters.add(filter);
            return this;
        }

        public Builder scoreAlias(String scoreAlias) {
            this.instance.scoreAlias = scoreAlias;
            return this;
        }
    }
}

