/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search.hybrid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.search.Apply;
import redis.clients.jedis.search.Filter;
import redis.clients.jedis.search.Limit;
import redis.clients.jedis.search.SearchProtocol;
import redis.clients.jedis.search.aggr.Group;
import redis.clients.jedis.search.aggr.SortedField;
import redis.clients.jedis.util.JedisAsserts;

@Experimental
public class FTHybridPostProcessingParams
implements IParams {
    private List<String> loadFields;
    private boolean loadAll;
    private Group groupBy;
    private final List<Apply> applies = new ArrayList<Apply>();
    private SortedField[] sortByFields;
    private boolean noSort;
    private Filter filter;
    private Limit limit;
    private static final String LOAD_ALL = "*";

    private FTHybridPostProcessingParams() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.loadAll || this.loadFields != null && !this.loadFields.isEmpty()) {
            args.add(SearchProtocol.SearchKeyword.LOAD);
            if (this.loadAll) {
                args.add(LOAD_ALL);
            } else {
                args.add(this.loadFields.size());
                for (String field : this.loadFields) {
                    if (!field.startsWith("@")) {
                        args.add("@" + field);
                        continue;
                    }
                    args.add(field);
                }
            }
        }
        if (this.groupBy != null) {
            ArrayList<Object> groupArgs = new ArrayList<Object>();
            this.groupBy.addArgs(groupArgs);
            args.add(SearchProtocol.SearchKeyword.GROUPBY);
            args.addObjects(groupArgs);
        }
        for (Apply apply : this.applies) {
            apply.addParams(args);
        }
        if (this.noSort) {
            args.add(SearchProtocol.SearchKeyword.NOSORT);
        } else if (this.sortByFields != null && this.sortByFields.length > 0) {
            args.add(SearchProtocol.SearchKeyword.SORTBY);
            args.add(this.sortByFields.length * 2);
            for (Iterator<Object> iterator : this.sortByFields) {
                args.add(((SortedField)((Object)iterator)).getField());
                args.add(((SortedField)((Object)iterator)).getOrder());
            }
        }
        if (this.filter != null) {
            this.filter.addParams(args);
        }
        if (this.limit != null) {
            this.limit.addParams(args);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FTHybridPostProcessingParams that = (FTHybridPostProcessingParams)o;
        return this.loadAll == that.loadAll && this.noSort == that.noSort && Objects.equals(this.loadFields, that.loadFields) && Objects.equals(this.groupBy, that.groupBy) && Objects.equals(this.applies, that.applies) && Arrays.equals(this.sortByFields, that.sortByFields) && Objects.equals(this.filter, that.filter) && Objects.equals(this.limit, that.limit);
    }

    public int hashCode() {
        int result = Objects.hash(this.loadFields, this.loadAll, this.groupBy, this.applies, this.noSort, this.filter, this.limit);
        result = 31 * result + Arrays.hashCode(this.sortByFields);
        return result;
    }

    static /* synthetic */ SortedField[] access$502(FTHybridPostProcessingParams x0, SortedField[] x1) {
        x0.sortByFields = x1;
        return x1;
    }

    public static class Builder {
        private final FTHybridPostProcessingParams instance = new FTHybridPostProcessingParams();

        public FTHybridPostProcessingParams build() {
            return this.instance;
        }

        public Builder load(String ... fields) {
            JedisAsserts.notNull(fields, "Fields must not be null");
            JedisAsserts.isTrue(fields.length > 0, "At least one field is required");
            for (String field : fields) {
                JedisAsserts.notNull(field, "Field names cannot be null");
                JedisAsserts.isFalse(FTHybridPostProcessingParams.LOAD_ALL.equals(field), "Cannot use '*' in load(). Use loadAll() instead to load all fields.");
            }
            this.instance.loadAll = false;
            this.instance.loadFields = Arrays.asList(fields);
            return this;
        }

        public Builder loadAll() {
            this.instance.loadAll = true;
            this.instance.loadFields = null;
            return this;
        }

        public Builder groupBy(Group group) {
            this.instance.groupBy = group;
            return this;
        }

        public Builder apply(Apply apply) {
            this.instance.applies.add(apply);
            return this;
        }

        public Builder sortBy(SortedField ... fields) {
            JedisAsserts.notNull(fields, "Sort by fields must not be null");
            JedisAsserts.isTrue(fields.length > 0, "At least one field is required");
            FTHybridPostProcessingParams.access$502(this.instance, fields);
            this.instance.noSort = false;
            return this;
        }

        public Builder noSort() {
            this.instance.noSort = true;
            FTHybridPostProcessingParams.access$502(this.instance, null);
            return this;
        }

        public Builder filter(Filter filter) {
            this.instance.filter = filter;
            return this;
        }

        public Builder limit(Limit limit) {
            this.instance.limit = limit;
            return this;
        }
    }
}

