/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.Endpoint;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.MultiDbConfig;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.annots.VisibleForTesting;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisValidationException;
import redis.clients.jedis.mcf.CircuitBreakerThresholdsAdapter;
import redis.clients.jedis.mcf.ConnectionInitializationContext;
import redis.clients.jedis.mcf.DatabaseSwitchEvent;
import redis.clients.jedis.mcf.HealthCheck;
import redis.clients.jedis.mcf.HealthCheckStrategy;
import redis.clients.jedis.mcf.HealthStatus;
import redis.clients.jedis.mcf.HealthStatusChangeEvent;
import redis.clients.jedis.mcf.HealthStatusManager;
import redis.clients.jedis.mcf.InitializationPolicy;
import redis.clients.jedis.mcf.JedisFailoverException;
import redis.clients.jedis.mcf.StatusTracker;
import redis.clients.jedis.mcf.SwitchReason;
import redis.clients.jedis.mcf.TrackingConnectionPool;
import redis.clients.jedis.providers.ConnectionProvider;
import redis.clients.jedis.util.Pool;

@Experimental
public class MultiDbConnectionProvider
implements ConnectionProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<Endpoint, Database> databaseMap = new ConcurrentHashMap<Endpoint, Database>();
    private volatile Database activeDatabase;
    private final Lock activeDatabaseChangeLock = new ReentrantLock(true);
    private Consumer<DatabaseSwitchEvent> databaseSwitchListener;
    private final List<Class<? extends Throwable>> fallbackExceptionList;
    private final HealthStatusManager healthStatusManager = new HealthStatusManager();
    private volatile boolean initializationComplete = false;
    private static final AtomicInteger failbackThreadCounter = new AtomicInteger(1);
    private final ScheduledExecutorService failbackScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "jedis-failback-" + failbackThreadCounter.getAndIncrement());
        t.setDaemon(true);
        return t;
    });
    private final RetryConfig retryConfig;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private final MultiDbConfig multiDbConfig;
    private final AtomicLong failoverFreezeUntil = new AtomicLong(0L);
    private final AtomicInteger failoverAttemptCount = new AtomicInteger(0);
    private static Comparator<Map.Entry<Endpoint, Database>> maxByWeight = Map.Entry.comparingByValue(Comparator.comparing(Database::getWeight));
    private static Predicate<Map.Entry<Endpoint, Database>> filterByHealth = c -> ((Database)c.getValue()).isHealthy();

    public MultiDbConnectionProvider(MultiDbConfig multiDbConfig) {
        MultiDbConfig.DatabaseConfig[] databaseConfigs;
        if (multiDbConfig == null) {
            throw new JedisValidationException("MultiDbConfig must not be NULL for MultiDbConnectionProvider");
        }
        this.multiDbConfig = multiDbConfig;
        MultiDbConfig.RetryConfig commandRetry = multiDbConfig.getCommandRetry();
        this.retryConfig = this.buildRetryConfig(commandRetry);
        MultiDbConfig.CircuitBreakerConfig failureDetector = multiDbConfig.getFailureDetector();
        this.circuitBreakerConfig = this.buildCircuitBreakerConfig(failureDetector, multiDbConfig);
        for (MultiDbConfig.DatabaseConfig config : databaseConfigs = multiDbConfig.getDatabaseConfigs()) {
            this.addDatabaseInternal(multiDbConfig, config);
        }
        StatusTracker statusTracker = new StatusTracker(this.healthStatusManager);
        this.activeDatabase = this.waitForInitializationPolicy(statusTracker);
        this.initializationComplete = true;
        Database temp = this.activeDatabase;
        if (!temp.isHealthy()) {
            this.waitForInitializationPolicy(statusTracker);
            this.switchToHealthyDatabase(SwitchReason.HEALTH_CHECK, temp);
        }
        this.fallbackExceptionList = multiDbConfig.getFallbackExceptionList();
        if (multiDbConfig.isFailbackSupported()) {
            long failbackInterval = multiDbConfig.getFailbackCheckInterval();
            this.failbackScheduler.scheduleAtFixedRate(this::periodicFailbackCheck, failbackInterval, failbackInterval, TimeUnit.MILLISECONDS);
        }
    }

    private RetryConfig buildRetryConfig(MultiDbConfig.RetryConfig commandRetry) {
        RetryConfig.Builder builder = RetryConfig.custom();
        builder.maxAttempts(commandRetry.getMaxAttempts());
        builder.intervalFunction(IntervalFunction.ofExponentialBackoff((Duration)commandRetry.getWaitDuration(), (double)commandRetry.getExponentialBackoffMultiplier()));
        builder.failAfterMaxAttempts(false);
        builder.retryExceptions((Class[])commandRetry.getIncludedExceptionList().stream().toArray(Class[]::new));
        List<Class> ignoreExceptions = commandRetry.getIgnoreExceptionList();
        if (ignoreExceptions != null) {
            builder.ignoreExceptions((Class[])ignoreExceptions.stream().toArray(Class[]::new));
        }
        return builder.build();
    }

    private CircuitBreakerConfig buildCircuitBreakerConfig(MultiDbConfig.CircuitBreakerConfig failureDetector, MultiDbConfig multiDbConfig) {
        CircuitBreakerConfig.Builder builder = CircuitBreakerConfig.custom();
        CircuitBreakerThresholdsAdapter adapter = new CircuitBreakerThresholdsAdapter(multiDbConfig);
        builder.minimumNumberOfCalls(adapter.getMinimumNumberOfCalls());
        builder.failureRateThreshold(adapter.getFailureRateThreshold());
        builder.slidingWindowSize(adapter.getSlidingWindowSize());
        builder.slidingWindowType(adapter.getSlidingWindowType());
        builder.recordExceptions((Class[])failureDetector.getIncludedExceptionList().stream().toArray(Class[]::new));
        builder.automaticTransitionFromOpenToHalfOpenEnabled(false);
        List<Class> ignoreExceptions = failureDetector.getIgnoreExceptionList();
        if (ignoreExceptions != null) {
            builder.ignoreExceptions((Class[])ignoreExceptions.stream().toArray(Class[]::new));
        }
        return builder.build();
    }

    public void add(MultiDbConfig.DatabaseConfig databaseConfig) {
        if (databaseConfig == null) {
            throw new JedisValidationException("DatabaseConfig must not be null");
        }
        Endpoint endpoint = databaseConfig.getEndpoint();
        if (this.databaseMap.containsKey(endpoint)) {
            throw new JedisValidationException("Endpoint " + endpoint + " already exists in the provider");
        }
        this.activeDatabaseChangeLock.lock();
        try {
            this.addDatabaseInternal(this.multiDbConfig, databaseConfig);
        }
        finally {
            this.activeDatabaseChangeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Endpoint endpoint) {
        if (endpoint == null) {
            throw new JedisValidationException("Endpoint must not be null");
        }
        if (!this.databaseMap.containsKey(endpoint)) {
            throw new JedisValidationException("Endpoint " + endpoint + " does not exist in the provider");
        }
        if (this.databaseMap.size() < 2) {
            throw new JedisValidationException("Cannot remove the last remaining endpoint");
        }
        this.log.debug("Removing endpoint {}", (Object)endpoint);
        Map.Entry<Endpoint, Database> notificationData = null;
        this.activeDatabaseChangeLock.lock();
        try {
            boolean isActiveDatabase;
            Database databaseToRemove = this.databaseMap.get(endpoint);
            boolean bl = isActiveDatabase = this.activeDatabase == databaseToRemove;
            if (isActiveDatabase) {
                this.log.info("Active database is being removed. Finding a new active database...");
                Map.Entry<Endpoint, Database> candidate = this.findWeightedHealthyDatabaseToIterate(databaseToRemove);
                if (candidate != null) {
                    Database selectedDatabase = candidate.getValue();
                    if (this.setActiveDatabase(selectedDatabase, true)) {
                        this.log.info("New active database set to {}", (Object)candidate.getKey());
                        notificationData = candidate;
                    }
                } else {
                    throw new JedisException("Database can not be removed due to no healthy database available to switch!");
                }
            }
            this.healthStatusManager.unregisterListener(endpoint, this::onHealthStatusChange);
            this.healthStatusManager.remove(endpoint);
            this.databaseMap.remove(endpoint);
            if (databaseToRemove != null) {
                databaseToRemove.setDisabled(true);
                databaseToRemove.close();
            }
        }
        finally {
            this.activeDatabaseChangeLock.unlock();
        }
        if (notificationData != null) {
            this.onDatabaseSwitch(SwitchReason.FORCED, notificationData.getKey(), notificationData.getValue());
        }
    }

    private void addDatabaseInternal(MultiDbConfig multiDbConfig, MultiDbConfig.DatabaseConfig config) {
        Database database;
        if (this.databaseMap.containsKey(config.getEndpoint())) {
            throw new JedisValidationException("Endpoint " + config.getEndpoint() + " already exists in the provider");
        }
        String databaseId = "database:" + config.getEndpoint();
        Retry retry = RetryRegistry.of((RetryConfig)this.retryConfig).retry(databaseId);
        Retry.EventPublisher retryPublisher = retry.getEventPublisher();
        retryPublisher.onRetry(event -> this.log.warn(String.valueOf(event)));
        retryPublisher.onError(event -> this.log.error(String.valueOf(event)));
        CircuitBreaker circuitBreaker = CircuitBreakerRegistry.of((CircuitBreakerConfig)this.circuitBreakerConfig).circuitBreaker(databaseId);
        CircuitBreaker.EventPublisher circuitBreakerEventPublisher = circuitBreaker.getEventPublisher();
        circuitBreakerEventPublisher.onCallNotPermitted(event -> this.log.error(String.valueOf(event)));
        circuitBreakerEventPublisher.onError(event -> this.log.error(String.valueOf(event)));
        circuitBreakerEventPublisher.onFailureRateExceeded(event -> this.log.error(String.valueOf(event)));
        circuitBreakerEventPublisher.onSlowCallRateExceeded(event -> this.log.error(String.valueOf(event)));
        TrackingConnectionPool pool = TrackingConnectionPool.builder().hostAndPort(this.hostPort(config.getEndpoint())).clientConfig(config.getJedisClientConfig()).poolConfig(config.getConnectionPoolConfig()).build();
        MultiDbConfig.StrategySupplier strategySupplier = config.getHealthCheckStrategySupplier();
        if (strategySupplier != null) {
            HealthCheckStrategy hcs = strategySupplier.get(this.hostPort(config.getEndpoint()), config.getJedisClientConfig());
            this.healthStatusManager.registerListener(config.getEndpoint(), this::onHealthStatusChange);
            HealthCheck hc = this.healthStatusManager.add(config.getEndpoint(), hcs);
            database = new Database(config.getEndpoint(), pool, retry, hc, circuitBreaker, config.getWeight(), multiDbConfig);
        } else {
            database = new Database(config.getEndpoint(), pool, retry, circuitBreaker, config.getWeight(), multiDbConfig);
        }
        this.databaseMap.put(config.getEndpoint(), database);
        circuitBreakerEventPublisher.onError(event -> database.evaluateThresholds(false));
    }

    private HostAndPort hostPort(Endpoint endpoint) {
        return new HostAndPort(endpoint.getHost(), endpoint.getPort());
    }

    @VisibleForTesting
    void onHealthStatusChange(HealthStatusChangeEvent eventArgs) {
        Endpoint endpoint = eventArgs.getEndpoint();
        HealthStatus newStatus = eventArgs.getNewStatus();
        this.log.debug("Health status changed for {} from {} to {}", new Object[]{endpoint, eventArgs.getOldStatus(), newStatus});
        Database databaseWithHealthChange = this.databaseMap.get(endpoint);
        if (databaseWithHealthChange == null) {
            return;
        }
        if (this.initializationComplete && !newStatus.isHealthy() && databaseWithHealthChange == this.activeDatabase) {
            databaseWithHealthChange.setGracePeriod();
            this.switchToHealthyDatabase(SwitchReason.HEALTH_CHECK, databaseWithHealthChange);
        }
    }

    @VisibleForTesting
    Database waitForInitializationPolicy(StatusTracker statusTracker) {
        InitializationPolicy policy = this.multiDbConfig.getInitializationPolicy();
        this.log.debug("Waiting for initialization policy {} to complete for {} configured databases", (Object)policy.getClass().getSimpleName(), (Object)this.databaseMap.size());
        ConnectionInitializationContext ctx = new ConnectionInitializationContext(this.databaseMap, this.healthStatusManager);
        InitializationPolicy.Decision decision = ctx.conformsTo(policy);
        this.log.debug("Initial policy evaluation: {} with context: {}", (Object)decision, (Object)ctx);
        if (decision == InitializationPolicy.Decision.FAIL) {
            throw new JedisConnectionException("Initialization failed due to initialization policy: " + ctx);
        }
        List<Map.Entry<Endpoint, Database>> sortedDatabases = this.databaseMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparing(Database::getWeight).reversed())).collect(Collectors.toList());
        for (Map.Entry entry : sortedDatabases) {
            Endpoint endpoint = (Endpoint)entry.getKey();
            Database database = (Database)entry.getValue();
            this.log.info("Evaluating database {} (weight: {})", (Object)endpoint, (Object)Float.valueOf(database.getWeight()));
            if (this.healthStatusManager.hasHealthCheck(endpoint)) {
                this.log.info("Health checks enabled for {}, waiting for result", (Object)endpoint);
                statusTracker.waitForHealthStatus(endpoint);
            } else {
                this.log.debug("No health check configured for database {}, defaulting to HEALTHY", (Object)endpoint);
            }
            ConnectionInitializationContext evalCtx = new ConnectionInitializationContext(this.databaseMap, this.healthStatusManager);
            InitializationPolicy.Decision d = evalCtx.conformsTo(policy);
            this.log.debug("Policy evaluation after {}: {}", (Object)endpoint, (Object)d);
            if (d == InitializationPolicy.Decision.SUCCESS) {
                return this.selectBestAvailableDatabase(sortedDatabases);
            }
            if (d != InitializationPolicy.Decision.FAIL) continue;
            throw new JedisConnectionException("Initialization failed due to initialization policy: " + evalCtx);
        }
        throw new JedisConnectionException("All configured databases are unhealthy. Cannot initialize MultiDbConnectionProvider.");
    }

    private Database selectBestAvailableDatabase(List<Map.Entry<Endpoint, Database>> sortedDatabases) {
        this.log.info("Selecting initial database from {} configured databases", (Object)sortedDatabases.size());
        for (Map.Entry<Endpoint, Database> entry : sortedDatabases) {
            HealthStatus status;
            Endpoint endpoint = entry.getKey();
            Database database = entry.getValue();
            if (this.healthStatusManager.hasHealthCheck(endpoint)) {
                status = this.healthStatusManager.getHealthStatus(endpoint);
            } else {
                this.log.info("No health check configured for database {}, defaulting to HEALTHY", (Object)endpoint);
                status = HealthStatus.HEALTHY;
            }
            if (status.isHealthy()) {
                this.log.info("Found healthy database: {} (weight: {})", (Object)endpoint, (Object)Float.valueOf(database.getWeight()));
                return database;
            }
            this.log.info("Database {} is unhealthy, trying next database", (Object)endpoint);
        }
        throw new JedisConnectionException("No healthy database available after initialization policy succeeded.");
    }

    @VisibleForTesting
    void periodicFailbackCheck() {
        try {
            Map.Entry<Endpoint, Database> bestCandidate = null;
            float bestWeight = this.activeDatabase.getWeight();
            for (Map.Entry<Endpoint, Database> entry : this.databaseMap.entrySet()) {
                Database database = entry.getValue();
                if (database == this.activeDatabase || !database.isHealthy() || !(database.getWeight() > bestWeight)) continue;
                bestCandidate = entry;
                bestWeight = database.getWeight();
            }
            if (bestCandidate != null) {
                Database selectedDatabase = (Database)bestCandidate.getValue();
                this.log.info("Performing failback from {} to {} (higher weight database available)", (Object)this.activeDatabase.getCircuitBreaker().getName(), (Object)selectedDatabase.getCircuitBreaker().getName());
                if (this.setActiveDatabase(selectedDatabase, true)) {
                    this.onDatabaseSwitch(SwitchReason.FAILBACK, bestCandidate.getKey(), selectedDatabase);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error during periodic failback check", (Throwable)e);
        }
    }

    Endpoint switchToHealthyDatabase(SwitchReason reason, Database iterateFrom) {
        Database database;
        boolean changed;
        Map.Entry<Endpoint, Database> databaseToIterate = this.findWeightedHealthyDatabaseToIterate(iterateFrom);
        if (databaseToIterate == null) {
            this.handleNoHealthyDatabase();
        }
        if (!(changed = this.setActiveDatabase(database = databaseToIterate.getValue(), false))) {
            return null;
        }
        this.failoverAttemptCount.set(0);
        this.onDatabaseSwitch(reason, databaseToIterate.getKey(), database);
        return databaseToIterate.getKey();
    }

    private void handleNoHealthyDatabase() {
        int currentAttemptCount;
        int max = this.multiDbConfig.getMaxNumFailoverAttempts();
        this.log.error("No healthy database available to switch to");
        if (this.failoverAttemptCount.get() > max) {
            throw new JedisFailoverException.JedisPermanentlyNotAvailableException();
        }
        int n = currentAttemptCount = this.markAsFreeze() ? this.failoverAttemptCount.incrementAndGet() : this.failoverAttemptCount.get();
        if (currentAttemptCount > max) {
            throw new JedisFailoverException.JedisPermanentlyNotAvailableException();
        }
        throw new JedisFailoverException.JedisTemporarilyNotAvailableException();
    }

    private boolean markAsFreeze() {
        long nextUntil;
        long now;
        long until = this.failoverFreezeUntil.get();
        return until <= (now = System.currentTimeMillis()) && this.failoverFreezeUntil.compareAndSet(until, nextUntil = now + (long)this.multiDbConfig.getDelayInBetweenFailoverAttempts());
    }

    @VisibleForTesting
    public void assertOperability() {
        Database current = this.activeDatabase;
        if (!current.isHealthy() && !this.canIterateFrom(current)) {
            this.handleNoHealthyDatabase();
        }
    }

    private Map.Entry<Endpoint, Database> findWeightedHealthyDatabaseToIterate(Database iterateFrom) {
        return this.databaseMap.entrySet().stream().filter(filterByHealth).filter(entry -> entry.getValue() != iterateFrom).max(maxByWeight).orElse(null);
    }

    public void validateTargetConnection(Endpoint endpoint) {
        Database database = this.databaseMap.get(endpoint);
        this.validateTargetConnection(database);
    }

    private void validateTargetConnection(Database database) {
        CircuitBreaker circuitBreaker = database.getCircuitBreaker();
        CircuitBreaker.State originalState = circuitBreaker.getState();
        try {
            circuitBreaker.transitionToClosedState();
            try (Connection targetConnection = database.getConnection();){
                targetConnection.ping();
            }
        }
        catch (Exception e) {
            if (CircuitBreaker.State.FORCED_OPEN.equals((Object)originalState)) {
                circuitBreaker.transitionToForcedOpenState();
            }
            throw new JedisValidationException(circuitBreaker.getName() + " failed to connect. Please check configuration and try again.", e);
        }
    }

    public Set<Endpoint> getEndpoints() {
        return new HashSet<Endpoint>(this.databaseMap.keySet());
    }

    public void setActiveDatabase(Endpoint endpoint) {
        if (endpoint == null) {
            throw new JedisValidationException("Provided endpoint is null. Please use one from the configuration");
        }
        Database database = this.databaseMap.get(endpoint);
        if (database == null) {
            throw new JedisValidationException("Provided endpoint: " + endpoint + " is not within the configured endpoints. Please use one from the configuration");
        }
        if (this.setActiveDatabase(database, true)) {
            this.onDatabaseSwitch(SwitchReason.FORCED, endpoint, database);
        }
    }

    public void forceActiveDatabase(Endpoint endpoint, long forcedActiveDuration) {
        Database database = this.databaseMap.get(endpoint);
        if (database == null) {
            throw new JedisValidationException("Provided endpoint: " + endpoint + " is not within the configured endpoints. Please use one from the configuration");
        }
        database.clearGracePeriod();
        if (!database.isHealthy()) {
            throw new JedisValidationException("Provided endpoint: " + endpoint + " is not healthy. Please consider a healthy endpoint from the configuration");
        }
        this.databaseMap.entrySet().stream().forEach(entry -> {
            if (entry.getKey() != endpoint) {
                ((Database)entry.getValue()).setGracePeriod(forcedActiveDuration);
            }
        });
        this.setActiveDatabase(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setActiveDatabase(Database database, boolean validateConnection) {
        boolean switched;
        Database oldDatabase;
        this.activeDatabaseChangeLock.lock();
        try {
            if (this.activeDatabase == database && !database.isCBForcedOpen()) {
                boolean bl = false;
                return bl;
            }
            if (validateConnection) {
                this.validateTargetConnection(database);
            }
            String originalDatabaseName = this.getDatabaseCircuitBreaker().getName();
            if (this.activeDatabase == database) {
                this.log.warn("Database/database endpoint '{}' successfully closed its circuit breaker", (Object)originalDatabaseName);
            } else {
                this.log.warn("Database/database endpoint successfully updated from '{}' to '{}'", (Object)originalDatabaseName, (Object)database.circuitBreaker.getName());
            }
            oldDatabase = this.activeDatabase;
            this.activeDatabase = database;
        }
        finally {
            this.activeDatabaseChangeLock.unlock();
        }
        boolean bl = switched = oldDatabase != database;
        if (switched && this.multiDbConfig.isFastFailover()) {
            this.log.info("Forcing disconnect of all active connections in old database: {}", (Object)oldDatabase.circuitBreaker.getName());
            oldDatabase.forceDisconnect();
            this.log.info("Disconnected all active connections in old database: {}", (Object)oldDatabase.circuitBreaker.getName());
        }
        return switched;
    }

    @Override
    public void close() {
        if (this.healthStatusManager != null) {
            this.healthStatusManager.close();
        }
        this.failbackScheduler.shutdown();
        try {
            if (!this.failbackScheduler.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.failbackScheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.failbackScheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        for (Database database : this.databaseMap.values()) {
            database.close();
        }
    }

    @Override
    public Connection getConnection() {
        return this.activeDatabase.getConnection();
    }

    public Connection getConnection(Endpoint endpoint) {
        return this.databaseMap.get(endpoint).getConnection();
    }

    @Override
    public Connection getConnection(CommandArguments args) {
        return this.activeDatabase.getConnection();
    }

    public Map<?, Pool<Connection>> getConnectionMap() {
        TrackingConnectionPool connectionPool = this.activeDatabase.connectionPool;
        return Collections.singletonMap(connectionPool.getFactory(), connectionPool);
    }

    public Database getDatabase() {
        return this.activeDatabase;
    }

    @VisibleForTesting
    public Database getDatabase(Endpoint endpoint) {
        return this.databaseMap.get(endpoint);
    }

    public Endpoint getActiveEndpoint() {
        return this.activeDatabase.getEndpoint();
    }

    public boolean isHealthy(Endpoint endpoint) {
        Database database = this.getDatabase(endpoint);
        if (database == null) {
            throw new JedisValidationException("Endpoint " + endpoint + " does not exist in the provider");
        }
        return database.isHealthy();
    }

    public CircuitBreaker getDatabaseCircuitBreaker() {
        return this.activeDatabase.getCircuitBreaker();
    }

    public boolean canIterateFrom(Database iterateFrom) {
        Map.Entry<Endpoint, Database> e = this.findWeightedHealthyDatabaseToIterate(iterateFrom);
        return e != null;
    }

    public void onDatabaseSwitch(SwitchReason reason, Endpoint endpoint, Database database) {
        if (this.databaseSwitchListener != null) {
            DatabaseSwitchEvent eventArgs = new DatabaseSwitchEvent(reason, endpoint, database);
            this.databaseSwitchListener.accept(eventArgs);
        }
    }

    public void setDatabaseSwitchListener(Consumer<DatabaseSwitchEvent> databaseSwitchListener) {
        this.databaseSwitchListener = databaseSwitchListener;
    }

    public List<Class<? extends Throwable>> getFallbackExceptionList() {
        return this.fallbackExceptionList;
    }

    public static class Database {
        private TrackingConnectionPool connectionPool;
        private final Retry retry;
        private final CircuitBreaker circuitBreaker;
        private final float weight;
        private final HealthCheck healthCheck;
        private final MultiDbConfig multiDbConfig;
        private boolean disabled = false;
        private final Endpoint endpoint;
        private volatile long gracePeriodEndsAt = 0L;
        private final Logger log = LoggerFactory.getLogger(this.getClass());

        private Database(Endpoint endpoint, TrackingConnectionPool connectionPool, Retry retry, CircuitBreaker circuitBreaker, float weight, MultiDbConfig multiDbConfig) {
            this.endpoint = endpoint;
            this.connectionPool = connectionPool;
            this.retry = retry;
            this.circuitBreaker = circuitBreaker;
            this.weight = weight;
            this.multiDbConfig = multiDbConfig;
            this.healthCheck = null;
        }

        private Database(Endpoint endpoint, TrackingConnectionPool connectionPool, Retry retry, HealthCheck hc, CircuitBreaker circuitBreaker, float weight, MultiDbConfig multiDbConfig) {
            this.endpoint = endpoint;
            this.connectionPool = connectionPool;
            this.retry = retry;
            this.circuitBreaker = circuitBreaker;
            this.weight = weight;
            this.multiDbConfig = multiDbConfig;
            this.healthCheck = hc;
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public Connection getConnection() {
            if (!this.isHealthy()) {
                throw new JedisConnectionException("Database is not healthy");
            }
            if (this.connectionPool.isClosed()) {
                this.connectionPool = TrackingConnectionPool.from(this.connectionPool);
            }
            return this.connectionPool.getResource();
        }

        @VisibleForTesting
        public ConnectionPool getConnectionPool() {
            return this.connectionPool;
        }

        public Retry getRetry() {
            return this.retry;
        }

        public CircuitBreaker getCircuitBreaker() {
            return this.circuitBreaker;
        }

        public HealthStatus getHealthStatus() {
            return this.healthCheck == null ? HealthStatus.HEALTHY : this.healthCheck.getStatus();
        }

        public float getWeight() {
            return this.weight;
        }

        public boolean isCBForcedOpen() {
            if (this.circuitBreaker.getState() == CircuitBreaker.State.FORCED_OPEN && !this.isInGracePeriod()) {
                this.log.info("Transitioning circuit breaker from FORCED_OPEN to CLOSED state due to end of grace period!");
                this.circuitBreaker.transitionToClosedState();
            }
            return this.circuitBreaker.getState() == CircuitBreaker.State.FORCED_OPEN;
        }

        public boolean isHealthy() {
            return this.getHealthStatus().isHealthy() && !this.isCBForcedOpen() && !this.disabled && !this.isInGracePeriod();
        }

        public boolean retryOnFailover() {
            return this.multiDbConfig.isRetryOnFailover();
        }

        public int getCircuitBreakerMinNumOfFailures() {
            return this.multiDbConfig.getFailureDetector().getMinNumOfFailures();
        }

        public float getCircuitBreakerFailureRateThreshold() {
            return this.multiDbConfig.getFailureDetector().getFailureRateThreshold();
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        public boolean isInGracePeriod() {
            return System.currentTimeMillis() < this.gracePeriodEndsAt;
        }

        public void setGracePeriod() {
            this.setGracePeriod(this.multiDbConfig.getGracePeriod());
        }

        public void setGracePeriod(long gracePeriod) {
            long endTime = System.currentTimeMillis() + gracePeriod;
            if (endTime < this.gracePeriodEndsAt) {
                return;
            }
            this.gracePeriodEndsAt = endTime;
        }

        public void clearGracePeriod() {
            this.gracePeriodEndsAt = 0L;
        }

        public boolean isFailbackSupported() {
            return this.multiDbConfig.isFailbackSupported();
        }

        public void forceDisconnect() {
            this.connectionPool.forceDisconnect();
        }

        public void close() {
            this.connectionPool.close();
        }

        void evaluateThresholds(boolean lastFailRecorded) {
            if (this.getCircuitBreaker().getState() == CircuitBreaker.State.CLOSED && Database.isThresholdsExceeded(this, lastFailRecorded)) {
                this.getCircuitBreaker().transitionToOpenState();
            }
        }

        private static boolean isThresholdsExceeded(Database database, boolean lastFailRecorded) {
            CircuitBreaker.Metrics metrics = database.getCircuitBreaker().getMetrics();
            int fails = metrics.getNumberOfFailedCalls() + (lastFailRecorded ? 0 : 1);
            int succ = metrics.getNumberOfSuccessfulCalls();
            if (fails >= database.getCircuitBreakerMinNumOfFailures()) {
                float ratePercentThreshold = database.getCircuitBreakerFailureRateThreshold();
                int total = fails + succ;
                if (total == 0) {
                    return false;
                }
                float failureRatePercent = (float)fails * 100.0f / (float)total;
                return failureRatePercent >= ratePercentThreshold;
            }
            return false;
        }

        public String toString() {
            return this.circuitBreaker.getName() + "{connectionPool=" + (Object)((Object)this.connectionPool) + ", retry=" + this.retry + ", circuitBreaker=" + this.circuitBreaker + ", weight=" + this.weight + ", healthStatus=" + (Object)((Object)this.getHealthStatus()) + ", multiDbConfig=" + this.multiDbConfig + '}';
        }
    }
}

