/*
 * Decompiled with CFR 0.152.
 */
package liquibase.analytics;

import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.analytics.configuration.AnalyticsConfigurationFactory;
import liquibase.analytics.configuration.LiquibaseRemoteAnalyticsConfiguration;
import liquibase.analytics.configuration.RemoteAnalyticsConfiguration;
import liquibase.integration.IntegrationDetails;
import liquibase.util.Cache;
import liquibase.util.ExceptionUtil;
import liquibase.util.LiquibaseUtil;
import liquibase.util.SystemUtil;
import liquibase.util.VersionUtils;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;

public class Event {
    public static final String JAVA_API_INTEGRATION_NAME = "JavaAPI";
    private static final Cache<Map<String, VersionUtils.LibraryInfo>> EXTENSIONS_CACHE = new Cache<Map>(() -> VersionUtils.getLibraryInfoMap());
    private final String command;
    private boolean reportsEnabled;
    private boolean dbclhEnabled;
    private boolean structuredLogsEnabled;
    private String operationOutcome;
    private String exceptionClass;
    private int chlog_sql;
    private int chlog_formattedSql;
    private int chlog_xml;
    private int chlog_json;
    private int chlog_yaml;
    private String databasePlatform;
    private String databaseVersion;
    private String liquibaseVersion = ExceptionUtil.doSilently(() -> LiquibaseUtil.getBuildVersionInfo());
    private String liquibaseInterface;
    private String javaVersion = ExceptionUtil.doSilently(() -> SystemUtil.getJavaVersion());
    private String os = ExceptionUtil.doSilently(() -> System.getProperty("os.name"));
    private String osVersion = ExceptionUtil.doSilently(() -> System.getProperty("os.version"));
    private String osArch = ExceptionUtil.doSilently(() -> System.getProperty("os.arch"));
    private List<Event> childEvents = new ArrayList<Event>();
    private boolean isDocker;
    private boolean isLiquibaseDocker;
    private boolean isAwsLiquibaseDocker;
    private boolean isGithubActions = Boolean.TRUE.equals(ExceptionUtil.doSilently(() -> BooleanUtils.toBoolean((String)System.getenv("GITHUB_ACTIONS"))));
    private boolean isCi = Boolean.TRUE.equals(ExceptionUtil.doSilently(() -> BooleanUtils.toBoolean((String)System.getenv("CI"))));
    private boolean isIO = Boolean.TRUE.equals(ExceptionUtil.doSilently(() -> BooleanUtils.toBoolean((String)System.getenv("isIO"))));
    private String timestamp = Instant.now().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);

    public Event(String command) {
        this.command = command;
        this.liquibaseInterface = ExceptionUtil.doSilently(() -> {
            IntegrationDetails integrationDetails = (IntegrationDetails)((Object)Scope.getCurrentScope().get((Enum)Scope.Attr.integrationDetails, IntegrationDetails.class));
            if (integrationDetails != null) {
                return integrationDetails.getName();
            }
            return JAVA_API_INTEGRATION_NAME;
        });
        this.isLiquibaseDocker = Boolean.TRUE.equals(ExceptionUtil.doSilently(() -> BooleanUtils.toBoolean((String)System.getenv("DOCKER_LIQUIBASE"))));
        this.isAwsLiquibaseDocker = Boolean.TRUE.equals(ExceptionUtil.doSilently(() -> BooleanUtils.toBoolean((String)System.getenv("DOCKER_AWS_LIQUIBASE"))));
        this.isDocker = Boolean.TRUE.equals(ExceptionUtil.doSilently(() -> {
            if (this.isLiquibaseDocker || this.isAwsLiquibaseDocker) {
                return true;
            }
            boolean dockerenvExists = Files.exists(Paths.get("/.dockerenv", new String[0]), new LinkOption[0]);
            if (dockerenvExists) {
                return true;
            }
            String cgroupContent = new String(Files.readAllBytes(Paths.get("/proc/1/cgroup", new String[0])));
            return cgroupContent.contains("docker") || cgroupContent.contains("kubepods");
        }));
    }

    public void incrementFormattedSqlChangelogCount() {
        ++this.chlog_formattedSql;
    }

    public void incrementSqlChangelogCount() {
        ++this.chlog_sql;
    }

    public void incrementYamlChangelogCount() {
        ++this.chlog_yaml;
    }

    public void incrementJsonChangelogCount() {
        ++this.chlog_json;
    }

    public void incrementXmlChangelogCount() {
        ++this.chlog_xml;
    }

    public Map<String, ?> getPropertiesAsMap() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (Fields field : Arrays.stream(Fields.values()).filter(f -> !Arrays.asList(Fields.childEvents, Fields.timestamp).contains(f)).collect(Collectors.toList())) {
            try {
                Field refField = this.getClass().getDeclaredField(field.toString());
                refField.setAccessible(true);
                Object value = refField.get(this);
                properties.put(field.toString(), value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        this.addExtensionsToProperties(properties);
        return properties;
    }

    private void addExtensionsToProperties(Map<String, Object> properties) {
        ExceptionUtil.doSilently(() -> {
            AnalyticsConfigurationFactory analyticsConfigurationFactory = Scope.getCurrentScope().getSingleton(AnalyticsConfigurationFactory.class);
            LiquibaseRemoteAnalyticsConfiguration analyticsConfiguration = (LiquibaseRemoteAnalyticsConfiguration)analyticsConfigurationFactory.getPlugin();
            List<RemoteAnalyticsConfiguration.ExtensionName> extensionNames = analyticsConfiguration.getExtensionNames();
            if (extensionNames != null) {
                for (RemoteAnalyticsConfiguration.ExtensionName extensionName : extensionNames) {
                    String manifestName = extensionName.getManifestName();
                    String displayName = extensionName.getDisplayName();
                    String extensionVersion = Event.getExtensionVersion(manifestName);
                    if (extensionVersion == null && properties.containsKey(displayName)) continue;
                    properties.put(displayName, extensionVersion);
                }
            }
        });
    }

    private static String getExtensionVersion(String extensionName) {
        return ExceptionUtil.doSilently(() -> {
            Map<String, VersionUtils.LibraryInfo> libraries = EXTENSIONS_CACHE.get();
            return libraries.get((Object)extensionName).version;
        });
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public boolean isReportsEnabled() {
        return this.reportsEnabled;
    }

    @Generated
    public boolean isDbclhEnabled() {
        return this.dbclhEnabled;
    }

    @Generated
    public boolean isStructuredLogsEnabled() {
        return this.structuredLogsEnabled;
    }

    @Generated
    public String getOperationOutcome() {
        return this.operationOutcome;
    }

    @Generated
    public String getExceptionClass() {
        return this.exceptionClass;
    }

    @Generated
    public int getChlog_sql() {
        return this.chlog_sql;
    }

    @Generated
    public int getChlog_formattedSql() {
        return this.chlog_formattedSql;
    }

    @Generated
    public int getChlog_xml() {
        return this.chlog_xml;
    }

    @Generated
    public int getChlog_json() {
        return this.chlog_json;
    }

    @Generated
    public int getChlog_yaml() {
        return this.chlog_yaml;
    }

    @Generated
    public String getDatabasePlatform() {
        return this.databasePlatform;
    }

    @Generated
    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    @Generated
    public String getLiquibaseVersion() {
        return this.liquibaseVersion;
    }

    @Generated
    public String getLiquibaseInterface() {
        return this.liquibaseInterface;
    }

    @Generated
    public String getJavaVersion() {
        return this.javaVersion;
    }

    @Generated
    public String getOs() {
        return this.os;
    }

    @Generated
    public String getOsVersion() {
        return this.osVersion;
    }

    @Generated
    public String getOsArch() {
        return this.osArch;
    }

    @Generated
    public List<Event> getChildEvents() {
        return this.childEvents;
    }

    @Generated
    public boolean isDocker() {
        return this.isDocker;
    }

    @Generated
    public boolean isLiquibaseDocker() {
        return this.isLiquibaseDocker;
    }

    @Generated
    public boolean isAwsLiquibaseDocker() {
        return this.isAwsLiquibaseDocker;
    }

    @Generated
    public boolean isGithubActions() {
        return this.isGithubActions;
    }

    @Generated
    public boolean isCi() {
        return this.isCi;
    }

    @Generated
    public boolean isIO() {
        return this.isIO;
    }

    @Generated
    public String getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setReportsEnabled(boolean reportsEnabled) {
        this.reportsEnabled = reportsEnabled;
    }

    @Generated
    public void setDbclhEnabled(boolean dbclhEnabled) {
        this.dbclhEnabled = dbclhEnabled;
    }

    @Generated
    public void setStructuredLogsEnabled(boolean structuredLogsEnabled) {
        this.structuredLogsEnabled = structuredLogsEnabled;
    }

    @Generated
    public void setOperationOutcome(String operationOutcome) {
        this.operationOutcome = operationOutcome;
    }

    @Generated
    public void setExceptionClass(String exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    @Generated
    public void setChlog_sql(int chlog_sql) {
        this.chlog_sql = chlog_sql;
    }

    @Generated
    public void setChlog_formattedSql(int chlog_formattedSql) {
        this.chlog_formattedSql = chlog_formattedSql;
    }

    @Generated
    public void setChlog_xml(int chlog_xml) {
        this.chlog_xml = chlog_xml;
    }

    @Generated
    public void setChlog_json(int chlog_json) {
        this.chlog_json = chlog_json;
    }

    @Generated
    public void setChlog_yaml(int chlog_yaml) {
        this.chlog_yaml = chlog_yaml;
    }

    @Generated
    public void setDatabasePlatform(String databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    @Generated
    public void setDatabaseVersion(String databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    @Generated
    public void setLiquibaseVersion(String liquibaseVersion) {
        this.liquibaseVersion = liquibaseVersion;
    }

    @Generated
    public void setLiquibaseInterface(String liquibaseInterface) {
        this.liquibaseInterface = liquibaseInterface;
    }

    @Generated
    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    @Generated
    public void setOs(String os) {
        this.os = os;
    }

    @Generated
    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    @Generated
    public void setOsArch(String osArch) {
        this.osArch = osArch;
    }

    @Generated
    public void setChildEvents(List<Event> childEvents) {
        this.childEvents = childEvents;
    }

    @Generated
    public void setDocker(boolean isDocker) {
        this.isDocker = isDocker;
    }

    @Generated
    public void setLiquibaseDocker(boolean isLiquibaseDocker) {
        this.isLiquibaseDocker = isLiquibaseDocker;
    }

    @Generated
    public void setAwsLiquibaseDocker(boolean isAwsLiquibaseDocker) {
        this.isAwsLiquibaseDocker = isAwsLiquibaseDocker;
    }

    @Generated
    public void setGithubActions(boolean isGithubActions) {
        this.isGithubActions = isGithubActions;
    }

    @Generated
    public void setCi(boolean isCi) {
        this.isCi = isCi;
    }

    @Generated
    public void setIO(boolean isIO) {
        this.isIO = isIO;
    }

    @Generated
    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReportsEnabled() != other.isReportsEnabled()) {
            return false;
        }
        if (this.isDbclhEnabled() != other.isDbclhEnabled()) {
            return false;
        }
        if (this.isStructuredLogsEnabled() != other.isStructuredLogsEnabled()) {
            return false;
        }
        if (this.getChlog_sql() != other.getChlog_sql()) {
            return false;
        }
        if (this.getChlog_formattedSql() != other.getChlog_formattedSql()) {
            return false;
        }
        if (this.getChlog_xml() != other.getChlog_xml()) {
            return false;
        }
        if (this.getChlog_json() != other.getChlog_json()) {
            return false;
        }
        if (this.getChlog_yaml() != other.getChlog_yaml()) {
            return false;
        }
        if (this.isDocker() != other.isDocker()) {
            return false;
        }
        if (this.isLiquibaseDocker() != other.isLiquibaseDocker()) {
            return false;
        }
        if (this.isAwsLiquibaseDocker() != other.isAwsLiquibaseDocker()) {
            return false;
        }
        if (this.isGithubActions() != other.isGithubActions()) {
            return false;
        }
        if (this.isCi() != other.isCi()) {
            return false;
        }
        if (this.isIO() != other.isIO()) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        String this$operationOutcome = this.getOperationOutcome();
        String other$operationOutcome = other.getOperationOutcome();
        if (this$operationOutcome == null ? other$operationOutcome != null : !this$operationOutcome.equals(other$operationOutcome)) {
            return false;
        }
        String this$exceptionClass = this.getExceptionClass();
        String other$exceptionClass = other.getExceptionClass();
        if (this$exceptionClass == null ? other$exceptionClass != null : !this$exceptionClass.equals(other$exceptionClass)) {
            return false;
        }
        String this$databasePlatform = this.getDatabasePlatform();
        String other$databasePlatform = other.getDatabasePlatform();
        if (this$databasePlatform == null ? other$databasePlatform != null : !this$databasePlatform.equals(other$databasePlatform)) {
            return false;
        }
        String this$databaseVersion = this.getDatabaseVersion();
        String other$databaseVersion = other.getDatabaseVersion();
        if (this$databaseVersion == null ? other$databaseVersion != null : !this$databaseVersion.equals(other$databaseVersion)) {
            return false;
        }
        String this$liquibaseVersion = this.getLiquibaseVersion();
        String other$liquibaseVersion = other.getLiquibaseVersion();
        if (this$liquibaseVersion == null ? other$liquibaseVersion != null : !this$liquibaseVersion.equals(other$liquibaseVersion)) {
            return false;
        }
        String this$liquibaseInterface = this.getLiquibaseInterface();
        String other$liquibaseInterface = other.getLiquibaseInterface();
        if (this$liquibaseInterface == null ? other$liquibaseInterface != null : !this$liquibaseInterface.equals(other$liquibaseInterface)) {
            return false;
        }
        String this$javaVersion = this.getJavaVersion();
        String other$javaVersion = other.getJavaVersion();
        if (this$javaVersion == null ? other$javaVersion != null : !this$javaVersion.equals(other$javaVersion)) {
            return false;
        }
        String this$os = this.getOs();
        String other$os = other.getOs();
        if (this$os == null ? other$os != null : !this$os.equals(other$os)) {
            return false;
        }
        String this$osVersion = this.getOsVersion();
        String other$osVersion = other.getOsVersion();
        if (this$osVersion == null ? other$osVersion != null : !this$osVersion.equals(other$osVersion)) {
            return false;
        }
        String this$osArch = this.getOsArch();
        String other$osArch = other.getOsArch();
        if (this$osArch == null ? other$osArch != null : !this$osArch.equals(other$osArch)) {
            return false;
        }
        List<Event> this$childEvents = this.getChildEvents();
        List<Event> other$childEvents = other.getChildEvents();
        if (this$childEvents == null ? other$childEvents != null : !((Object)this$childEvents).equals(other$childEvents)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReportsEnabled() ? 79 : 97);
        result = result * 59 + (this.isDbclhEnabled() ? 79 : 97);
        result = result * 59 + (this.isStructuredLogsEnabled() ? 79 : 97);
        result = result * 59 + this.getChlog_sql();
        result = result * 59 + this.getChlog_formattedSql();
        result = result * 59 + this.getChlog_xml();
        result = result * 59 + this.getChlog_json();
        result = result * 59 + this.getChlog_yaml();
        result = result * 59 + (this.isDocker() ? 79 : 97);
        result = result * 59 + (this.isLiquibaseDocker() ? 79 : 97);
        result = result * 59 + (this.isAwsLiquibaseDocker() ? 79 : 97);
        result = result * 59 + (this.isGithubActions() ? 79 : 97);
        result = result * 59 + (this.isCi() ? 79 : 97);
        result = result * 59 + (this.isIO() ? 79 : 97);
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        String $operationOutcome = this.getOperationOutcome();
        result = result * 59 + ($operationOutcome == null ? 43 : $operationOutcome.hashCode());
        String $exceptionClass = this.getExceptionClass();
        result = result * 59 + ($exceptionClass == null ? 43 : $exceptionClass.hashCode());
        String $databasePlatform = this.getDatabasePlatform();
        result = result * 59 + ($databasePlatform == null ? 43 : $databasePlatform.hashCode());
        String $databaseVersion = this.getDatabaseVersion();
        result = result * 59 + ($databaseVersion == null ? 43 : $databaseVersion.hashCode());
        String $liquibaseVersion = this.getLiquibaseVersion();
        result = result * 59 + ($liquibaseVersion == null ? 43 : $liquibaseVersion.hashCode());
        String $liquibaseInterface = this.getLiquibaseInterface();
        result = result * 59 + ($liquibaseInterface == null ? 43 : $liquibaseInterface.hashCode());
        String $javaVersion = this.getJavaVersion();
        result = result * 59 + ($javaVersion == null ? 43 : $javaVersion.hashCode());
        String $os = this.getOs();
        result = result * 59 + ($os == null ? 43 : $os.hashCode());
        String $osVersion = this.getOsVersion();
        result = result * 59 + ($osVersion == null ? 43 : $osVersion.hashCode());
        String $osArch = this.getOsArch();
        result = result * 59 + ($osArch == null ? 43 : $osArch.hashCode());
        List<Event> $childEvents = this.getChildEvents();
        result = result * 59 + ($childEvents == null ? 43 : ((Object)$childEvents).hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Event(command=" + this.getCommand() + ", reportsEnabled=" + this.isReportsEnabled() + ", dbclhEnabled=" + this.isDbclhEnabled() + ", structuredLogsEnabled=" + this.isStructuredLogsEnabled() + ", operationOutcome=" + this.getOperationOutcome() + ", exceptionClass=" + this.getExceptionClass() + ", chlog_sql=" + this.getChlog_sql() + ", chlog_formattedSql=" + this.getChlog_formattedSql() + ", chlog_xml=" + this.getChlog_xml() + ", chlog_json=" + this.getChlog_json() + ", chlog_yaml=" + this.getChlog_yaml() + ", databasePlatform=" + this.getDatabasePlatform() + ", databaseVersion=" + this.getDatabaseVersion() + ", liquibaseVersion=" + this.getLiquibaseVersion() + ", liquibaseInterface=" + this.getLiquibaseInterface() + ", javaVersion=" + this.getJavaVersion() + ", os=" + this.getOs() + ", osVersion=" + this.getOsVersion() + ", osArch=" + this.getOsArch() + ", childEvents=" + String.valueOf(this.getChildEvents()) + ", isDocker=" + this.isDocker() + ", isLiquibaseDocker=" + this.isLiquibaseDocker() + ", isAwsLiquibaseDocker=" + this.isAwsLiquibaseDocker() + ", isGithubActions=" + this.isGithubActions() + ", isCi=" + this.isCi() + ", isIO=" + this.isIO() + ", timestamp=" + this.getTimestamp() + ")";
    }

    @Generated
    public static enum Fields {
        command,
        reportsEnabled,
        dbclhEnabled,
        structuredLogsEnabled,
        operationOutcome,
        exceptionClass,
        chlog_sql,
        chlog_formattedSql,
        chlog_xml,
        chlog_json,
        chlog_yaml,
        databasePlatform,
        databaseVersion,
        liquibaseVersion,
        liquibaseInterface,
        javaVersion,
        os,
        osVersion,
        osArch,
        childEvents,
        isDocker,
        isLiquibaseDocker,
        isAwsLiquibaseDocker,
        isGithubActions,
        isCi,
        isIO,
        timestamp;

    }
}

