/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.java.decompiler.code.BytecodeVersion;
import org.jetbrains.java.decompiler.struct.StructRecordComponent;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructRecordAttribute
extends StructGeneralAttribute {
    private List<StructRecordComponent> components;

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool, BytecodeVersion version) throws IOException {
        int componentCount = data.readUnsignedShort();
        StructRecordComponent[] components = new StructRecordComponent[componentCount];
        for (int i = 0; i < componentCount; ++i) {
            components[i] = StructRecordComponent.create(data, pool, version);
        }
        this.components = Arrays.asList(components);
    }

    public List<StructRecordComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<StructRecordComponent> components) {
        this.components = components;
    }
}

