package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"io"

	"strings"
)

// DownloadImportExcelTemplateResponse Response Object
type DownloadImportExcelTemplateResponse struct {
	HttpStatusCode int           `json:"-"`
	Body           io.ReadCloser `json:"-" type:"stream"`
}

func (o DownloadImportExcelTemplateResponse) Consume(writer io.Writer) (int64, error) {
	written, err := io.Copy(writer, o.Body)
	defer o.Body.Close()

	return written, err
}

func (o DownloadImportExcelTemplateResponse) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "DownloadImportExcelTemplateResponse struct{}"
	}

	return strings.Join([]string{"DownloadImportExcelTemplateResponse", string(data)}, " ")
}
