package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// Tag **参数解释**： 标签信息。 **约束限制**： 不涉及。 **取值范围**： 不涉及。 **默认取值**： 不涉及。
type Tag struct {

	// **参数解释**： 标签的键。 **约束限制**： 不涉及。 **取值范围**： - 输入标签键的最大长度为128个unicode字符，不能为空字符串，且首尾字符不能为空格； - 不能包含“=”,“*”,“<”,“>”,“\\\\”,“,”,“|”,“/”； - 只能包含大写字母（A-Z）、小写字母（a-z）、数字（0-9）和特殊字符（中划线-、下划线_）以及中文字符； **默认取值**： 不涉及。
	Key *string `json:"key,omitempty"`

	// **参数解释**： 标签的值。 **约束限制**： 不涉及。 **取值范围**： - 输入标签值的最大长度为256个字符，首尾字符不能为空格，可以为空字符串。 - 不能包含“=”,“*”,“<”,“>”,“\\\\”,“,”,“|”,“/”。 - 只能包含大写字母（A-Z）、小写字母（a-z）、数字（0-9）和特殊字符（中划线-、下划线_）以及中文字符。 **默认取值**： 不涉及。
	Value *string `json:"value,omitempty"`
}

func (o Tag) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "Tag struct{}"
	}

	return strings.Join([]string{"Tag", string(data)}, " ")
}
