//autogenerated:yes
//nolint:revive,misspell,govet,lll
package storm32

// Message to a gimbal manager to correct the gimbal roll angle. This message is typically used to manually correct for a tilted horizon in operation. A gimbal device is never to react to this message.
type MessageStorm32GimbalManagerCorrectRoll struct {
	// System ID
	TargetSystem uint8
	// Component ID
	TargetComponent uint8
	// Gimbal ID of the gimbal manager to address (component ID or 1-6 for non-MAVLink gimbal, 0 for all gimbals). Send command multiple times for more than one but not all gimbals.
	GimbalId uint8
	// Client which is contacting the gimbal manager (must be set).
	Client MAV_STORM32_GIMBAL_MANAGER_CLIENT `mavenum:"uint8"`
	// Roll angle (positive to roll to the right).
	Roll float32
}

// GetID implements the message.Message interface.
func (*MessageStorm32GimbalManagerCorrectRoll) GetID() uint32 {
	return 60014
}
