//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package development

import (
	"fmt"
	"strconv"
)

// Signal spoofing state in a GPS receiver.
type GPS_SPOOFING_STATE uint64

const (
	// The GPS receiver does not provide GPS signal spoofing info.
	GPS_SPOOFING_STATE_UNKNOWN GPS_SPOOFING_STATE = 0
	// The GPS receiver detected no signal spoofing.
	GPS_SPOOFING_STATE_OK GPS_SPOOFING_STATE = 1
	// The GPS receiver detected and mitigated signal spoofing.
	GPS_SPOOFING_STATE_MITIGATED GPS_SPOOFING_STATE = 2
	// The GPS receiver detected signal spoofing but still has a fix.
	GPS_SPOOFING_STATE_DETECTED GPS_SPOOFING_STATE = 3
)

var value_to_label_GPS_SPOOFING_STATE = map[GPS_SPOOFING_STATE]string{
	GPS_SPOOFING_STATE_UNKNOWN:   "GPS_SPOOFING_STATE_UNKNOWN",
	GPS_SPOOFING_STATE_OK:        "GPS_SPOOFING_STATE_OK",
	GPS_SPOOFING_STATE_MITIGATED: "GPS_SPOOFING_STATE_MITIGATED",
	GPS_SPOOFING_STATE_DETECTED:  "GPS_SPOOFING_STATE_DETECTED",
}

var label_to_value_GPS_SPOOFING_STATE = map[string]GPS_SPOOFING_STATE{
	"GPS_SPOOFING_STATE_UNKNOWN":   GPS_SPOOFING_STATE_UNKNOWN,
	"GPS_SPOOFING_STATE_OK":        GPS_SPOOFING_STATE_OK,
	"GPS_SPOOFING_STATE_MITIGATED": GPS_SPOOFING_STATE_MITIGATED,
	"GPS_SPOOFING_STATE_DETECTED":  GPS_SPOOFING_STATE_DETECTED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GPS_SPOOFING_STATE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_GPS_SPOOFING_STATE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GPS_SPOOFING_STATE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_GPS_SPOOFING_STATE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GPS_SPOOFING_STATE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GPS_SPOOFING_STATE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
