//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

type MAV_ODID_VER_ACC uint64

const (
	// The vertical accuracy is unknown.
	MAV_ODID_VER_ACC_UNKNOWN MAV_ODID_VER_ACC = 0
	// The vertical accuracy is smaller than 150 meter.
	MAV_ODID_VER_ACC_150_METER MAV_ODID_VER_ACC = 1
	// The vertical accuracy is smaller than 45 meter.
	MAV_ODID_VER_ACC_45_METER MAV_ODID_VER_ACC = 2
	// The vertical accuracy is smaller than 25 meter.
	MAV_ODID_VER_ACC_25_METER MAV_ODID_VER_ACC = 3
	// The vertical accuracy is smaller than 10 meter.
	MAV_ODID_VER_ACC_10_METER MAV_ODID_VER_ACC = 4
	// The vertical accuracy is smaller than 3 meter.
	MAV_ODID_VER_ACC_3_METER MAV_ODID_VER_ACC = 5
	// The vertical accuracy is smaller than 1 meter.
	MAV_ODID_VER_ACC_1_METER MAV_ODID_VER_ACC = 6
)

var value_to_label_MAV_ODID_VER_ACC = map[MAV_ODID_VER_ACC]string{
	MAV_ODID_VER_ACC_UNKNOWN:   "MAV_ODID_VER_ACC_UNKNOWN",
	MAV_ODID_VER_ACC_150_METER: "MAV_ODID_VER_ACC_150_METER",
	MAV_ODID_VER_ACC_45_METER:  "MAV_ODID_VER_ACC_45_METER",
	MAV_ODID_VER_ACC_25_METER:  "MAV_ODID_VER_ACC_25_METER",
	MAV_ODID_VER_ACC_10_METER:  "MAV_ODID_VER_ACC_10_METER",
	MAV_ODID_VER_ACC_3_METER:   "MAV_ODID_VER_ACC_3_METER",
	MAV_ODID_VER_ACC_1_METER:   "MAV_ODID_VER_ACC_1_METER",
}

var label_to_value_MAV_ODID_VER_ACC = map[string]MAV_ODID_VER_ACC{
	"MAV_ODID_VER_ACC_UNKNOWN":   MAV_ODID_VER_ACC_UNKNOWN,
	"MAV_ODID_VER_ACC_150_METER": MAV_ODID_VER_ACC_150_METER,
	"MAV_ODID_VER_ACC_45_METER":  MAV_ODID_VER_ACC_45_METER,
	"MAV_ODID_VER_ACC_25_METER":  MAV_ODID_VER_ACC_25_METER,
	"MAV_ODID_VER_ACC_10_METER":  MAV_ODID_VER_ACC_10_METER,
	"MAV_ODID_VER_ACC_3_METER":   MAV_ODID_VER_ACC_3_METER,
	"MAV_ODID_VER_ACC_1_METER":   MAV_ODID_VER_ACC_1_METER,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_ODID_VER_ACC) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_ODID_VER_ACC[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_ODID_VER_ACC) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_ODID_VER_ACC[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_ODID_VER_ACC(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_ODID_VER_ACC) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
