//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Illuminator module error flags (bitmap, 0 means no error)
type ILLUMINATOR_ERROR_FLAGS uint64

const (
	// Illuminator thermal throttling error.
	ILLUMINATOR_ERROR_FLAGS_THERMAL_THROTTLING ILLUMINATOR_ERROR_FLAGS = 1
	// Illuminator over temperature shutdown error.
	ILLUMINATOR_ERROR_FLAGS_OVER_TEMPERATURE_SHUTDOWN ILLUMINATOR_ERROR_FLAGS = 2
	// Illuminator thermistor failure.
	ILLUMINATOR_ERROR_FLAGS_THERMISTOR_FAILURE ILLUMINATOR_ERROR_FLAGS = 4
)

var values_ILLUMINATOR_ERROR_FLAGS = []ILLUMINATOR_ERROR_FLAGS{
	ILLUMINATOR_ERROR_FLAGS_THERMAL_THROTTLING,
	ILLUMINATOR_ERROR_FLAGS_OVER_TEMPERATURE_SHUTDOWN,
	ILLUMINATOR_ERROR_FLAGS_THERMISTOR_FAILURE,
}

var value_to_label_ILLUMINATOR_ERROR_FLAGS = map[ILLUMINATOR_ERROR_FLAGS]string{
	ILLUMINATOR_ERROR_FLAGS_THERMAL_THROTTLING:        "ILLUMINATOR_ERROR_FLAGS_THERMAL_THROTTLING",
	ILLUMINATOR_ERROR_FLAGS_OVER_TEMPERATURE_SHUTDOWN: "ILLUMINATOR_ERROR_FLAGS_OVER_TEMPERATURE_SHUTDOWN",
	ILLUMINATOR_ERROR_FLAGS_THERMISTOR_FAILURE:        "ILLUMINATOR_ERROR_FLAGS_THERMISTOR_FAILURE",
}

var label_to_value_ILLUMINATOR_ERROR_FLAGS = map[string]ILLUMINATOR_ERROR_FLAGS{
	"ILLUMINATOR_ERROR_FLAGS_THERMAL_THROTTLING":        ILLUMINATOR_ERROR_FLAGS_THERMAL_THROTTLING,
	"ILLUMINATOR_ERROR_FLAGS_OVER_TEMPERATURE_SHUTDOWN": ILLUMINATOR_ERROR_FLAGS_OVER_TEMPERATURE_SHUTDOWN,
	"ILLUMINATOR_ERROR_FLAGS_THERMISTOR_FAILURE":        ILLUMINATOR_ERROR_FLAGS_THERMISTOR_FAILURE,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e ILLUMINATOR_ERROR_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_ILLUMINATOR_ERROR_FLAGS {
		if e&val == val {
			names = append(names, value_to_label_ILLUMINATOR_ERROR_FLAGS[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *ILLUMINATOR_ERROR_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask ILLUMINATOR_ERROR_FLAGS
	for _, label := range labels {
		if value, ok := label_to_value_ILLUMINATOR_ERROR_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= ILLUMINATOR_ERROR_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e ILLUMINATOR_ERROR_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
