//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

type GOPRO_PROTUNE_SHARPNESS uint64

const (
	// Low Sharpness.
	GOPRO_PROTUNE_SHARPNESS_LOW GOPRO_PROTUNE_SHARPNESS = 0
	// Medium Sharpness.
	GOPRO_PROTUNE_SHARPNESS_MEDIUM GOPRO_PROTUNE_SHARPNESS = 1
	// High Sharpness.
	GOPRO_PROTUNE_SHARPNESS_HIGH GOPRO_PROTUNE_SHARPNESS = 2
)

var value_to_label_GOPRO_PROTUNE_SHARPNESS = map[GOPRO_PROTUNE_SHARPNESS]string{
	GOPRO_PROTUNE_SHARPNESS_LOW:    "GOPRO_PROTUNE_SHARPNESS_LOW",
	GOPRO_PROTUNE_SHARPNESS_MEDIUM: "GOPRO_PROTUNE_SHARPNESS_MEDIUM",
	GOPRO_PROTUNE_SHARPNESS_HIGH:   "GOPRO_PROTUNE_SHARPNESS_HIGH",
}

var label_to_value_GOPRO_PROTUNE_SHARPNESS = map[string]GOPRO_PROTUNE_SHARPNESS{
	"GOPRO_PROTUNE_SHARPNESS_LOW":    GOPRO_PROTUNE_SHARPNESS_LOW,
	"GOPRO_PROTUNE_SHARPNESS_MEDIUM": GOPRO_PROTUNE_SHARPNESS_MEDIUM,
	"GOPRO_PROTUNE_SHARPNESS_HIGH":   GOPRO_PROTUNE_SHARPNESS_HIGH,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GOPRO_PROTUNE_SHARPNESS) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_GOPRO_PROTUNE_SHARPNESS[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GOPRO_PROTUNE_SHARPNESS) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_GOPRO_PROTUNE_SHARPNESS[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GOPRO_PROTUNE_SHARPNESS(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GOPRO_PROTUNE_SHARPNESS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
