//autogenerated:yes
//nolint:revive,misspell,govet,lll
package common

// Set gimbal manager pitch and yaw angles (high rate message). This message is to be sent to the gimbal manager (e.g. from a ground station) and will be ignored by gimbal devices. Angles and rates can be set to NaN according to use case. Use MAV_CMD_DO_GIMBAL_MANAGER_PITCHYAW for low-rate adjustments that require confirmation.
type MessageGimbalManagerSetPitchyaw struct {
	// System ID
	TargetSystem uint8
	// Component ID
	TargetComponent uint8
	// High level gimbal manager flags to use.
	Flags GIMBAL_MANAGER_FLAGS `mavenum:"uint32"`
	// Component ID of gimbal device to address (or 1-6 for non-MAVLink gimbal), 0 for all gimbal device components. Send command multiple times for more than one gimbal (but not all gimbals).
	GimbalDeviceId uint8
	// Pitch angle (positive: up, negative: down, NaN to be ignored).
	Pitch float32
	// Yaw angle (positive: to the right, negative: to the left, NaN to be ignored).
	Yaw float32
	// Pitch angular rate (positive: up, negative: down, NaN to be ignored).
	PitchRate float32
	// Yaw angular rate (positive: to the right, negative: to the left, NaN to be ignored).
	YawRate float32
}

// GetID implements the message.Message interface.
func (*MessageGimbalManagerSetPitchyaw) GetID() uint32 {
	return 287
}
