//autogenerated:yes
//nolint:revive,misspell,govet,lll
package common

// Report status of a command. Includes feedback whether the command was executed. The command microservice is documented at https://mavlink.io/en/services/command.html
type MessageCommandAck struct {
	// Command ID (of acknowledged command).
	Command MAV_CMD `mavenum:"uint16"`
	// Result of command.
	Result MAV_RESULT `mavenum:"uint8"`
	// The progress percentage when result is MAV_RESULT_IN_PROGRESS. Values: [0-100], or UINT8_MAX if the progress is unknown.
	Progress uint8 `mavext:"true"`
	// Additional result information. Can be set with a command-specific enum containing command-specific error reasons for why the command might be denied. If used, the associated enum must be documented in the corresponding MAV_CMD (this enum should have a 0 value to indicate "unused" or "unknown").
	ResultParam2 int32 `mavext:"true"`
	// System ID of the target recipient. This is the ID of the system that sent the command for which this COMMAND_ACK is an acknowledgement.
	TargetSystem uint8 `mavext:"true"`
	// Component ID of the target recipient. This is the ID of the system that sent the command for which this COMMAND_ACK is an acknowledgement.
	TargetComponent uint8 `mavext:"true"`
}

// GetID implements the message.Message interface.
func (*MessageCommandAck) GetID() uint32 {
	return 77
}
