//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Type of GPS fix
type GPS_FIX_TYPE uint64

const (
	// No GPS connected
	GPS_FIX_TYPE_NO_GPS GPS_FIX_TYPE = 0
	// No position information, GPS is connected
	GPS_FIX_TYPE_NO_FIX GPS_FIX_TYPE = 1
	// 2D position
	GPS_FIX_TYPE_2D_FIX GPS_FIX_TYPE = 2
	// 3D position
	GPS_FIX_TYPE_3D_FIX GPS_FIX_TYPE = 3
	// DGPS/SBAS aided 3D position
	GPS_FIX_TYPE_DGPS GPS_FIX_TYPE = 4
	// RTK float, 3D position
	GPS_FIX_TYPE_RTK_FLOAT GPS_FIX_TYPE = 5
	// RTK Fixed, 3D position
	GPS_FIX_TYPE_RTK_FIXED GPS_FIX_TYPE = 6
	// Static fixed, typically used for base stations
	GPS_FIX_TYPE_STATIC GPS_FIX_TYPE = 7
	// PPP, 3D position.
	GPS_FIX_TYPE_PPP GPS_FIX_TYPE = 8
)

var value_to_label_GPS_FIX_TYPE = map[GPS_FIX_TYPE]string{
	GPS_FIX_TYPE_NO_GPS:    "GPS_FIX_TYPE_NO_GPS",
	GPS_FIX_TYPE_NO_FIX:    "GPS_FIX_TYPE_NO_FIX",
	GPS_FIX_TYPE_2D_FIX:    "GPS_FIX_TYPE_2D_FIX",
	GPS_FIX_TYPE_3D_FIX:    "GPS_FIX_TYPE_3D_FIX",
	GPS_FIX_TYPE_DGPS:      "GPS_FIX_TYPE_DGPS",
	GPS_FIX_TYPE_RTK_FLOAT: "GPS_FIX_TYPE_RTK_FLOAT",
	GPS_FIX_TYPE_RTK_FIXED: "GPS_FIX_TYPE_RTK_FIXED",
	GPS_FIX_TYPE_STATIC:    "GPS_FIX_TYPE_STATIC",
	GPS_FIX_TYPE_PPP:       "GPS_FIX_TYPE_PPP",
}

var label_to_value_GPS_FIX_TYPE = map[string]GPS_FIX_TYPE{
	"GPS_FIX_TYPE_NO_GPS":    GPS_FIX_TYPE_NO_GPS,
	"GPS_FIX_TYPE_NO_FIX":    GPS_FIX_TYPE_NO_FIX,
	"GPS_FIX_TYPE_2D_FIX":    GPS_FIX_TYPE_2D_FIX,
	"GPS_FIX_TYPE_3D_FIX":    GPS_FIX_TYPE_3D_FIX,
	"GPS_FIX_TYPE_DGPS":      GPS_FIX_TYPE_DGPS,
	"GPS_FIX_TYPE_RTK_FLOAT": GPS_FIX_TYPE_RTK_FLOAT,
	"GPS_FIX_TYPE_RTK_FIXED": GPS_FIX_TYPE_RTK_FIXED,
	"GPS_FIX_TYPE_STATIC":    GPS_FIX_TYPE_STATIC,
	"GPS_FIX_TYPE_PPP":       GPS_FIX_TYPE_PPP,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GPS_FIX_TYPE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_GPS_FIX_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GPS_FIX_TYPE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_GPS_FIX_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GPS_FIX_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GPS_FIX_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
