//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Zoom types for MAV_CMD_SET_CAMERA_ZOOM
type CAMERA_ZOOM_TYPE uint64

const (
	// Zoom one step increment (-1 for wide, 1 for tele)
	ZOOM_TYPE_STEP CAMERA_ZOOM_TYPE = 0
	// Continuous normalized zoom in/out rate until stopped. Range -1..1, negative: wide, positive: narrow/tele, 0 to stop zooming. Other values should be clipped to the range.
	ZOOM_TYPE_CONTINUOUS CAMERA_ZOOM_TYPE = 1
	// Zoom value as proportion of full camera range (a percentage value between 0.0 and 100.0)
	ZOOM_TYPE_RANGE CAMERA_ZOOM_TYPE = 2
	// Zoom value/variable focal length in millimetres. Note that there is no message to get the valid zoom range of the camera, so this can type can only be used for cameras where the zoom range is known (implying that this cannot reliably be used in a GCS for an arbitrary camera)
	ZOOM_TYPE_FOCAL_LENGTH CAMERA_ZOOM_TYPE = 3
	// Zoom value as horizontal field of view in degrees.
	ZOOM_TYPE_HORIZONTAL_FOV CAMERA_ZOOM_TYPE = 4
)

var value_to_label_CAMERA_ZOOM_TYPE = map[CAMERA_ZOOM_TYPE]string{
	ZOOM_TYPE_STEP:           "ZOOM_TYPE_STEP",
	ZOOM_TYPE_CONTINUOUS:     "ZOOM_TYPE_CONTINUOUS",
	ZOOM_TYPE_RANGE:          "ZOOM_TYPE_RANGE",
	ZOOM_TYPE_FOCAL_LENGTH:   "ZOOM_TYPE_FOCAL_LENGTH",
	ZOOM_TYPE_HORIZONTAL_FOV: "ZOOM_TYPE_HORIZONTAL_FOV",
}

var label_to_value_CAMERA_ZOOM_TYPE = map[string]CAMERA_ZOOM_TYPE{
	"ZOOM_TYPE_STEP":           ZOOM_TYPE_STEP,
	"ZOOM_TYPE_CONTINUOUS":     ZOOM_TYPE_CONTINUOUS,
	"ZOOM_TYPE_RANGE":          ZOOM_TYPE_RANGE,
	"ZOOM_TYPE_FOCAL_LENGTH":   ZOOM_TYPE_FOCAL_LENGTH,
	"ZOOM_TYPE_HORIZONTAL_FOV": ZOOM_TYPE_HORIZONTAL_FOV,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e CAMERA_ZOOM_TYPE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_CAMERA_ZOOM_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *CAMERA_ZOOM_TYPE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_CAMERA_ZOOM_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = CAMERA_ZOOM_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e CAMERA_ZOOM_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
