//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

type GOPRO_RESOLUTION uint64

const (
	// 848 x 480 (480p).
	GOPRO_RESOLUTION_480p GOPRO_RESOLUTION = 0
	// 1280 x 720 (720p).
	GOPRO_RESOLUTION_720p GOPRO_RESOLUTION = 1
	// 1280 x 960 (960p).
	GOPRO_RESOLUTION_960p GOPRO_RESOLUTION = 2
	// 1920 x 1080 (1080p).
	GOPRO_RESOLUTION_1080p GOPRO_RESOLUTION = 3
	// 1920 x 1440 (1440p).
	GOPRO_RESOLUTION_1440p GOPRO_RESOLUTION = 4
	// 2704 x 1440 (2.7k-17:9).
	GOPRO_RESOLUTION_2_7k_17_9 GOPRO_RESOLUTION = 5
	// 2704 x 1524 (2.7k-16:9).
	GOPRO_RESOLUTION_2_7k_16_9 GOPRO_RESOLUTION = 6
	// 2704 x 2028 (2.7k-4:3).
	GOPRO_RESOLUTION_2_7k_4_3 GOPRO_RESOLUTION = 7
	// 3840 x 2160 (4k-16:9).
	GOPRO_RESOLUTION_4k_16_9 GOPRO_RESOLUTION = 8
	// 4096 x 2160 (4k-17:9).
	GOPRO_RESOLUTION_4k_17_9 GOPRO_RESOLUTION = 9
	// 1280 x 720 (720p-SuperView).
	GOPRO_RESOLUTION_720p_SUPERVIEW GOPRO_RESOLUTION = 10
	// 1920 x 1080 (1080p-SuperView).
	GOPRO_RESOLUTION_1080p_SUPERVIEW GOPRO_RESOLUTION = 11
	// 2704 x 1520 (2.7k-SuperView).
	GOPRO_RESOLUTION_2_7k_SUPERVIEW GOPRO_RESOLUTION = 12
	// 3840 x 2160 (4k-SuperView).
	GOPRO_RESOLUTION_4k_SUPERVIEW GOPRO_RESOLUTION = 13
)

var value_to_label_GOPRO_RESOLUTION = map[GOPRO_RESOLUTION]string{
	GOPRO_RESOLUTION_480p:            "GOPRO_RESOLUTION_480p",
	GOPRO_RESOLUTION_720p:            "GOPRO_RESOLUTION_720p",
	GOPRO_RESOLUTION_960p:            "GOPRO_RESOLUTION_960p",
	GOPRO_RESOLUTION_1080p:           "GOPRO_RESOLUTION_1080p",
	GOPRO_RESOLUTION_1440p:           "GOPRO_RESOLUTION_1440p",
	GOPRO_RESOLUTION_2_7k_17_9:       "GOPRO_RESOLUTION_2_7k_17_9",
	GOPRO_RESOLUTION_2_7k_16_9:       "GOPRO_RESOLUTION_2_7k_16_9",
	GOPRO_RESOLUTION_2_7k_4_3:        "GOPRO_RESOLUTION_2_7k_4_3",
	GOPRO_RESOLUTION_4k_16_9:         "GOPRO_RESOLUTION_4k_16_9",
	GOPRO_RESOLUTION_4k_17_9:         "GOPRO_RESOLUTION_4k_17_9",
	GOPRO_RESOLUTION_720p_SUPERVIEW:  "GOPRO_RESOLUTION_720p_SUPERVIEW",
	GOPRO_RESOLUTION_1080p_SUPERVIEW: "GOPRO_RESOLUTION_1080p_SUPERVIEW",
	GOPRO_RESOLUTION_2_7k_SUPERVIEW:  "GOPRO_RESOLUTION_2_7k_SUPERVIEW",
	GOPRO_RESOLUTION_4k_SUPERVIEW:    "GOPRO_RESOLUTION_4k_SUPERVIEW",
}

var label_to_value_GOPRO_RESOLUTION = map[string]GOPRO_RESOLUTION{
	"GOPRO_RESOLUTION_480p":            GOPRO_RESOLUTION_480p,
	"GOPRO_RESOLUTION_720p":            GOPRO_RESOLUTION_720p,
	"GOPRO_RESOLUTION_960p":            GOPRO_RESOLUTION_960p,
	"GOPRO_RESOLUTION_1080p":           GOPRO_RESOLUTION_1080p,
	"GOPRO_RESOLUTION_1440p":           GOPRO_RESOLUTION_1440p,
	"GOPRO_RESOLUTION_2_7k_17_9":       GOPRO_RESOLUTION_2_7k_17_9,
	"GOPRO_RESOLUTION_2_7k_16_9":       GOPRO_RESOLUTION_2_7k_16_9,
	"GOPRO_RESOLUTION_2_7k_4_3":        GOPRO_RESOLUTION_2_7k_4_3,
	"GOPRO_RESOLUTION_4k_16_9":         GOPRO_RESOLUTION_4k_16_9,
	"GOPRO_RESOLUTION_4k_17_9":         GOPRO_RESOLUTION_4k_17_9,
	"GOPRO_RESOLUTION_720p_SUPERVIEW":  GOPRO_RESOLUTION_720p_SUPERVIEW,
	"GOPRO_RESOLUTION_1080p_SUPERVIEW": GOPRO_RESOLUTION_1080p_SUPERVIEW,
	"GOPRO_RESOLUTION_2_7k_SUPERVIEW":  GOPRO_RESOLUTION_2_7k_SUPERVIEW,
	"GOPRO_RESOLUTION_4k_SUPERVIEW":    GOPRO_RESOLUTION_4k_SUPERVIEW,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GOPRO_RESOLUTION) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_GOPRO_RESOLUTION[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GOPRO_RESOLUTION) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_GOPRO_RESOLUTION[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GOPRO_RESOLUTION(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GOPRO_RESOLUTION) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
